/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.ui;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.jboss.forge.addon.javaee.rest.ui.AbstractRestNewCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class CrossOriginResourceSharingFilterCommand
extends AbstractRestNewCommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="Access-Control-Allow-Origin", defaultValue="*", description="The Access-Control-Allow-Origin header indicates whether a resource can be shared based by returning the value of the Origin request header, \"*\", or \"null\" in the response")
    private UIInput<String> accessControlAllowOrigin;
    @Inject
    @WithAttributes(label="Access-Control-Allow-Methods", description="The Access-Control-Allow-Methods header indicates, as part of the response to a preflight request, which methods can be used during the actual request.")
    private UISelectMany<String> accessControlAllowMethods;
    @Inject
    @WithAttributes(label="Access-Control-Allow-Headers", description="The Access-Control-Allow-Headers header indicates, as part of the response to a preflight request, which header field names can be used during the actual request")
    private UIInputMany<String> accessControlAllowHeaders;
    @Inject
    @WithAttributes(label="Access-Control-Allow-Credentials", defaultValue="true", description="The Access-Control-Allow-Credentials header indicates whether the response to request can be exposed when the omit credentials flag is unset. When part of the response to a preflight request it indicates that the actual request can include user credentials.")
    private UIInput<Boolean> accessControlAllowCredentials;

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.getNamed().setDefaultValue((Object)"NewCrossOriginResourceSharingFilter");
        this.accessControlAllowHeaders.setValue(Arrays.asList("Content-Type", "User-Agent", "X-Requested-With", "X-Requested-By", "Cache-Control"));
        this.accessControlAllowMethods.setValueChoices(Arrays.asList("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS"));
        this.accessControlAllowMethods.setValue(Arrays.asList("GET", "POST", "PUT", "DELETE"));
        builder.add(this.accessControlAllowMethods).add(this.accessControlAllowHeaders).add(this.accessControlAllowOrigin).add(this.accessControlAllowCredentials);
    }

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("REST: New " + this.getType()).description("Generate a " + this.getType());
    }

    protected String getType() {
        return "Cross Origin Resource Sharing Filter";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource source) throws Exception {
        source.addAnnotation(Provider.class);
        source.addAnnotation(PreMatching.class);
        source.addInterface(ContainerResponseFilter.class);
        MethodSource method = ((MethodSource)((MethodSource)source.addMethod().setName("filter")).setPublic()).setReturnTypeVoid();
        method.addAnnotation(Override.class);
        method.addParameter(ContainerRequestContext.class, "request");
        method.addParameter(ContainerResponseContext.class, "response");
        StringBuilder body = new StringBuilder();
        body.append("response.getHeaders().putSingle(\"Access-Control-Allow-Origin\",\"").append((String)this.accessControlAllowOrigin.getValue()).append("\");");
        body.append(OperatingSystemUtils.getLineSeparator());
        body.append("response.getHeaders().putSingle(\"Access-Control-Allow-Methods\",\"");
        List list = Lists.toList((Iterable)this.accessControlAllowMethods.getValue());
        body.append(Strings.join((Object[])list.toArray(), (String)", "));
        body.append("\");");
        body.append(OperatingSystemUtils.getLineSeparator());
        body.append("response.getHeaders().putSingle(\"Access-Control-Allow-Headers\",\"");
        list = Lists.toList((Iterable)this.accessControlAllowHeaders.getValue());
        body.append(Strings.join((Object[])list.toArray(), (String)", "));
        body.append("\");");
        if (((Boolean)this.accessControlAllowCredentials.getValue()).booleanValue()) {
            body.append("response.getHeaders().putSingle(\"Access-Control-Allow-Credentials\",\"true\");");
        }
        method.setBody(body.toString());
        return source;
    }
}

