/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.Id;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.ejb.EJBFacet;
import org.jboss.forge.addon.javaee.ejb.ui.EJBSetupWizardImpl;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupWizard;
import org.jboss.forge.addon.javaee.rest.RestFacet;
import org.jboss.forge.addon.javaee.rest.generation.RestGenerationContext;
import org.jboss.forge.addon.javaee.rest.generation.RestResourceGenerator;
import org.jboss.forge.addon.javaee.rest.generator.impl.EntityBasedResourceGenerator;
import org.jboss.forge.addon.javaee.rest.ui.RestSetupWizard;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.text.Inflector;
import org.jboss.forge.addon.ui.command.PrerequisiteCommandsProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.forge.roaster.model.Member;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

@FacetConstraint(value={JavaSourceFacet.class})
public class RestEndpointFromEntityCommand
extends AbstractJavaEECommand
implements PrerequisiteCommandsProvider {
    @Inject
    @WithAttributes(label="Content Type", defaultValue="application/json", required=true)
    private UIInputMany<String> contentType;
    @Inject
    @WithAttributes(label="Targets", required=true)
    private UISelectMany<JavaClassSource> targets;
    @Inject
    @WithAttributes(label="Generator", required=true)
    private UISelectOne<RestResourceGenerator> generator;
    @Inject
    @WithAttributes(label="Persistence Unit", required=true)
    private UISelectOne<String> persistenceUnit;
    @Inject
    @WithAttributes(label="Target Package Name", required=true, type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> packageName;
    @Inject
    @WithAttributes(label="Overwrite existing classes?", enabled=false, defaultValue="false")
    private UIInput<Boolean> overwrite;
    @Inject
    private EntityBasedResourceGenerator defaultResourceGenerator;
    @Inject
    private Inflector inflector;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("REST: Generate Endpoints From Entities").description("Generate REST endpoints from JPA entities").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JAX-RS"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Project project = this.getSelectedProject(context);
        JPAFacet persistenceFacet = (JPAFacet)project.getFacet(JPAFacet.class);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        List allEntities = persistenceFacet.getAllEntities();
        ArrayList<JavaClassSource> supportedEntities = new ArrayList<JavaClassSource>();
        for (JavaClassSource entity : allEntities) {
            if (!this.isEntityWithSimpleKey(entity)) continue;
            supportedEntities.add(entity);
        }
        this.targets.setValueChoices(supportedEntities);
        this.targets.setItemLabelConverter((Converter)new Converter<JavaClassSource, String>(){

            public String convert(JavaClassSource source) {
                return source == null ? null : source.getQualifiedName();
            }
        });
        ArrayList<String> persistenceUnits = new ArrayList<String>();
        List allUnits = ((PersistenceCommonDescriptor)persistenceFacet.getConfig()).getAllPersistenceUnit();
        for (PersistenceUnitCommon persistenceUnit : allUnits) {
            persistenceUnits.add(persistenceUnit.getName());
        }
        if (!persistenceUnits.isEmpty()) {
            ((UISelectOne)this.persistenceUnit.setValueChoices(persistenceUnits)).setDefaultValue(persistenceUnits.get(0));
        }
        this.packageName.setDefaultValue((Object)(javaSourceFacet.getBasePackage() + ".rest"));
        this.contentType.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                ArrayList<String> options = new ArrayList<String>();
                options.add("application/xml");
                options.add("application/json");
                return options;
            }
        });
        this.generator.setDefaultValue((Object)this.defaultResourceGenerator);
        if (context.getProvider().isGUI()) {
            this.generator.setItemLabelConverter((Converter)new Converter<RestResourceGenerator, String>(){

                public String convert(RestResourceGenerator source) {
                    return source == null ? null : source.getDescription();
                }
            });
        } else {
            this.generator.setItemLabelConverter((Converter)new Converter<RestResourceGenerator, String>(){

                public String convert(RestResourceGenerator source) {
                    return source == null ? null : source.getName();
                }
            });
        }
        builder.add(this.targets).add(this.generator).add(this.contentType).add(this.packageName).add(this.persistenceUnit).add(this.overwrite);
    }

    private boolean isEntityWithSimpleKey(JavaClassSource entity) {
        for (Member member : entity.getMembers()) {
            if (!member.hasAnnotation(Id.class)) continue;
            return true;
        }
        return false;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        RestGenerationContext generationContext = this.createContextFor(uiContext);
        Set<JavaClassSource> endpoints = this.generateEndpoints(generationContext);
        Project project = generationContext.getProject();
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        ArrayList<JavaResource> selection = new ArrayList<JavaResource>();
        for (JavaClassSource javaClass : endpoints) {
            selection.add(javaSourceFacet.saveJavaSource((JavaSource)javaClass));
        }
        uiContext.setSelection(selection);
        return Results.success((String)"Endpoint created");
    }

    private Set<JavaClassSource> generateEndpoints(RestGenerationContext generationContext) throws Exception {
        RestResourceGenerator selectedGenerator = (RestResourceGenerator)this.generator.getValue();
        HashSet<JavaClassSource> classes = new HashSet<JavaClassSource>();
        for (JavaClassSource target : this.targets.getValue()) {
            generationContext.setEntity(target);
            List artifacts = selectedGenerator.generateFrom(generationContext);
            classes.addAll(artifacts);
        }
        return classes;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    private RestGenerationContext createContextFor(UIContext context) {
        RestGenerationContext generationContext = new RestGenerationContext();
        generationContext.setProject(this.getSelectedProject(context));
        generationContext.setContentType(Lists.toList((Iterable)this.contentType.getValue()));
        generationContext.setPersistenceUnitName((String)this.persistenceUnit.getValue());
        generationContext.setTargetPackageName((String)this.packageName.getValue());
        generationContext.setInflector(this.inflector);
        return generationContext;
    }

    public NavigationResult getPrerequisiteCommands(UIContext context) {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        Project project = this.getSelectedProject(context);
        if (project != null) {
            if (!project.hasFacet(RestFacet.class)) {
                builder.add(RestSetupWizard.class);
            }
            if (!project.hasFacet(JPAFacet.class)) {
                builder.add(JPASetupWizard.class);
            }
            if (!project.hasFacet(EJBFacet.class)) {
                builder.add(EJBSetupWizardImpl.class);
            }
        }
        return builder.build();
    }
}

