/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.ui;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;
import org.jboss.forge.addon.javaee.rest.ui.AbstractRestNewCommand;
import org.jboss.forge.addon.javaee.rest.ui.RestMethod;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.text.Inflector;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class RestNewEndpointCommand
extends AbstractRestNewCommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="Methods", description="REST methods to be defined", defaultValue="GET")
    private UISelectMany<RestMethod> methods;
    @Inject
    @WithAttributes(label="Path", description="The root path of the endpoint")
    private UIInput<String> path;
    @Inject
    private Inflector inflector;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("REST: New Endpoint").description("Creates a new REST Endpoint");
    }

    protected String getType() {
        return "REST";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.methods).add(this.path);
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource source) throws Exception {
        if (this.path.hasValue()) {
            source.addAnnotation(Path.class).setStringValue("/" + (String)this.path.getValue());
        } else {
            source.addAnnotation(Path.class).setStringValue("/" + this.inflector.lowerCamelCase(((String)this.getNamed().getValue()).replace("Endpoint", ""), new char[0]));
        }
        for (RestMethod method : this.methods.getValue()) {
            MethodSource doGet = ((MethodSource)((MethodSource)source.addMethod().setPublic()).setName(method.getMethodName())).setReturnType("javax.ws.rs.core.Response");
            doGet.addAnnotation(method.getMethodAnnotation());
            switch (method) {
                case GET: {
                    doGet.addAnnotation(Produces.class).setStringArrayValue(new String[]{"text/plain"});
                    doGet.setBody("return Response.ok(\"method " + method.getMethodName() + " invoked\").build();");
                    break;
                }
                case POST: {
                    source.addImport(UriBuilder.class);
                    doGet.addAnnotation(Consumes.class).setStringArrayValue(new String[]{"text/plain", "application/json"});
                    doGet.addParameter(String.class, "entity");
                    doGet.setBody("return Response.created(UriBuilder.fromResource(" + (String)this.getNamed().getValue() + ".class).build()).build();");
                    break;
                }
                case PUT: {
                    source.addImport(UriBuilder.class);
                    doGet.addAnnotation(Consumes.class).setStringArrayValue(new String[]{"text/plain", "application/json"});
                    doGet.addParameter(String.class, "entity");
                    doGet.setBody("return Response.created(UriBuilder.fromResource(" + (String)this.getNamed().getValue() + ".class).build()).build();");
                    break;
                }
                case DELETE: {
                    doGet.addAnnotation(Path.class).setStringValue("/{id}");
                    doGet.addParameter(Long.class, "id").addAnnotation(PathParam.class).setStringValue("id");
                    doGet.setBody("return Response.noContent().build();");
                }
            }
        }
        return source;
    }
}

