/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.ui.setup;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.rest.RestFacet;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategyFactory;
import org.jboss.forge.addon.javaee.rest.ui.RestSetupWizard;
import org.jboss.forge.addon.javaee.rest.ui.setup.RestActivatorType;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;

@FacetConstraint(value={JavaSourceFacet.class})
public class RestSetupWizardImpl
extends AbstractJavaEECommand
implements RestSetupWizard {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="JAX-RS Version", defaultValue="1.1")
    private UISelectOne<RestFacet> jaxrsVersion;
    @Inject
    @WithAttributes(required=true, label="Configuration Strategy", type="org.jboss.forge.inputType.RADIO")
    private UISelectOne<RestActivatorType> config;
    @Inject
    @WithAttributes(label="Application Path", description="The Application path for the REST resources", defaultValue="/rest", required=true)
    private UIInput<String> applicationPath;
    @Inject
    @WithAttributes(label="Target Package", type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Class Name", defaultValue="RestApplication")
    private UIInput<String> className;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("REST: Setup").description("Setup REST in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JAX-RS"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureActivationStrategy(builder.getUIContext());
        builder.add(this.jaxrsVersion).add(this.applicationPath).add(this.config).add(this.targetPackage).add(this.className);
    }

    private void configureActivationStrategy(UIContext context) {
        this.config.setDefaultValue((Object)RestActivatorType.APP_CLASS);
        Callable<Boolean> appClassChosen = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RestActivatorType.APP_CLASS == RestSetupWizardImpl.this.config.getValue();
            }
        };
        if (context.getProvider().isGUI()) {
            this.config.setItemLabelConverter((Converter)new Converter<RestActivatorType, String>(){

                public String convert(RestActivatorType source) {
                    return source != null ? source.getDescription() : null;
                }
            });
        }
        ((UIInput)this.targetPackage.setRequired((Callable)appClassChosen)).setEnabled((Callable)appClassChosen);
        ((UIInput)this.className.setRequired((Callable)appClassChosen)).setEnabled((Callable)appClassChosen);
        Project project = this.getSelectedProject(context);
        this.targetPackage.setDefaultValue((Object)(((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage() + ".rest"));
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        RestFacet facet = (RestFacet)this.jaxrsVersion.getValue();
        if (this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)facet)) {
            RestConfigurationStrategy strategy;
            String path = (String)this.applicationPath.getValue();
            if (this.config.getValue() == RestActivatorType.WEB_XML) {
                strategy = RestConfigurationStrategyFactory.createUsingWebXml((String)path);
            } else {
                JavaClassSource javaClass = (JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setPackage((String)this.targetPackage.getValue())).setName((String)this.className.getValue());
                strategy = RestConfigurationStrategyFactory.createUsingJavaClass((String)path, (JavaClassSource)javaClass);
            }
            facet.setConfigurationStrategy(strategy);
            return Results.success((String)"JAX-RS has been installed.");
        }
        return Results.fail((String)"Could not install JAX-RS.");
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

