/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.security.ui;

import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={ServletFacet.class})
public class AddLoginConfigCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Security realm", required=true)
    private UIInput<String> securityRealm;
    @Inject
    @WithAttributes(label="Authentication method", required=true)
    private UIInput<String> authMethod;

    protected boolean isProjectRequired() {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.authMethod.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                return Arrays.asList("BASIC", "DIGEST", "FORM", "CLIENT_CERT");
            }
        });
        builder.add(this.securityRealm).add(this.authMethod);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ServletFacet servletFacet = (ServletFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ServletFacet.class);
        servletFacet.addLoginConfig((String)this.authMethod.getValue(), (String)this.securityRealm.getValue());
        return Results.success((String)("Security realm " + (String)this.securityRealm.getValue() + " and authentication method " + (String)this.authMethod.getValue() + " were configured"));
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Security: Add login config").description("Adds a login config element to the current project").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "Security"}));
    }
}

