/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.security.ui;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.security.TransportGuarantee;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={ServletFacet.class})
public class AddSecurityConstraintCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Display name", shortName=110, description="The display name of this security constraint")
    private UIInput<String> displayName;
    @Inject
    @WithAttributes(label="Web resource name", shortName=119, required=true, description="The collective name of the web resources covered by this constraint")
    private UIInput<String> webResourceName;
    @Inject
    @WithAttributes(label="Description", shortName=100, description="Short description of this web resource collection")
    private UIInput<String> description;
    @Inject
    @WithAttributes(label="URL patterns", shortName=117, required=true, description="The URL patterns that will be covered by ths web resource collection")
    private UIInputMany<String> urlPatterns;
    @Inject
    @WithAttributes(label="HTTP methods", shortName=104, description="The HTTP methods that will be covered by ths web resource collection")
    private UIInputMany<String> httpMethods;
    @Inject
    @WithAttributes(label="Security roles", shortName=114, description="The roles permitted to perform the constrained requests")
    private UIInputMany<String> securityRoles;
    @Inject
    @WithAttributes(label="Enable user data constraint", shortName=117, description="Establish a requirement to access the constrained request over a protected transport layer")
    private UIInput<Boolean> enableUserDataConstraint;
    @Inject
    @WithAttributes(label="Transport guarantee", shortName=116, description="The type of requirement for used data constraint")
    private UIInput<TransportGuarantee> transportGuarantee;

    public void initializeUI(UIBuilder builder) throws Exception {
        ServletFacet servletFacet = (ServletFacet)this.getSelectedProject(builder.getUIContext()).getFacet(ServletFacet.class);
        final List roles = servletFacet.getSecurityRoles();
        this.httpMethods.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                return Arrays.asList("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS");
            }
        });
        this.securityRoles.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                return roles;
            }
        });
        this.enableUserDataConstraint.setDefaultValue((Object)false);
        this.transportGuarantee.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)AddSecurityConstraintCommand.this.enableUserDataConstraint.getValue();
            }
        });
        builder.add(this.displayName).add(this.webResourceName).add(this.description).add(this.urlPatterns).add(this.httpMethods).add(this.securityRoles).add(this.enableUserDataConstraint).add(this.transportGuarantee);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ServletFacet servletFacet = (ServletFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ServletFacet.class);
        if (this.securityRoles.getValue().iterator().hasNext()) {
            this.createNonExistingRoles(servletFacet, this.securityRoles.getValue());
        }
        TransportGuarantee transportGuaranteeValue = null;
        if (((Boolean)this.enableUserDataConstraint.getValue()).booleanValue()) {
            transportGuaranteeValue = (TransportGuarantee)this.transportGuarantee.getValue();
        }
        servletFacet.addSecurityConstraint((String)this.displayName.getValue(), (String)this.webResourceName.getValue(), (String)this.description.getValue(), this.httpMethods.getValue(), this.urlPatterns.getValue(), this.securityRoles.getValue(), transportGuaranteeValue);
        return Results.success((String)"Security constraint was added successfully");
    }

    private void createNonExistingRoles(ServletFacet<?> servletFacet, Iterable<String> securityRoles) {
        List existingRoles = servletFacet.getSecurityRoles();
        for (String securityRole : securityRoles) {
            if (existingRoles.contains(securityRole)) continue;
            servletFacet.addSecurityRole(securityRole);
        }
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Security: Add Constraint").description("Add security constraint").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "Security"}));
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

