/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.security.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={ServletFacet.class})
public class AddSecurityRoleCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Role name", required=true, requiredMessage="You should enter the role name")
    private UIInput<String> named;

    protected boolean isProjectRequired() {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.named);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        ServletFacet servletFacet = (ServletFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ServletFacet.class);
        String roleName = (String)this.named.getValue();
        servletFacet.addSecurityRole(roleName);
        return Results.success((String)("Security role " + roleName + " was created"));
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Security: Add Role").description("Add security role").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "Security"}));
    }
}

