/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.security.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={ServletFacet.class})
public class RemoveSecurityRoleCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Role to remove", required=true, requiredMessage="You should enter the role to be removed")
    private UISelectOne<String> named;

    protected boolean isProjectRequired() {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.named.setValueChoices((Iterable)this.getServletFacet(builder.getUIContext()).getSecurityRoles());
        builder.add(this.named);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String roleToBeRemoved = (String)this.named.getValue();
        if (this.getServletFacet(context.getUIContext()).removeSecurityRole(roleToBeRemoved)) {
            return Results.success((String)("Role " + roleToBeRemoved + " was removed successfully"));
        }
        return Results.fail((String)("Role " + roleToBeRemoved + " could not be removed. Probably it does not exist"));
    }

    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && this.getServletFacet(context).getSecurityRoles().size() > 0;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Security: Remove Role").description("Remove security role").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "Security"}));
    }

    private ServletFacet<?> getServletFacet(UIContext uiContext) {
        return (ServletFacet)this.getSelectedProject(uiContext).getFacet(ServletFacet.class);
    }
}

