/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.servlet;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.security.TransportGuarantee;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.shrinkwrap.descriptor.api.javaee.SecurityRoleCommonType;
import org.jboss.shrinkwrap.descriptor.api.webapp.WebAppCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon.AuthConstraintCommonType;
import org.jboss.shrinkwrap.descriptor.api.webcommon.SecurityConstraintCommonType;
import org.jboss.shrinkwrap.descriptor.api.webcommon.UserDataConstraintCommonType;
import org.jboss.shrinkwrap.descriptor.api.webcommon.WebResourceCollectionCommonType;

public abstract class AbstractServletFacet<DESCRIPTOR extends WebAppCommonDescriptor>
extends AbstractJavaEEFacet
implements ServletFacet<DESCRIPTOR> {
    @Inject
    public AbstractServletFacet(DependencyInstaller installer) {
        super(installer);
    }

    public String getSpecName() {
        return "Servlet";
    }

    @Override
    public boolean isInstalled() {
        Project project = (Project)this.getFaceted();
        DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return super.isInstalled() && webRoot.exists();
    }

    @Override
    public boolean install() {
        Project project;
        DirectoryResource webRoot;
        if (!this.isInstalled() && !(webRoot = ((WebResourcesFacet)(project = (Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory()).exists()) {
            webRoot.mkdirs();
        }
        return super.install();
    }

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getFaceted();
        DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return (FileResource)webRoot.getChild("WEB-INF" + File.separator + "web.xml");
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource webRoot) {
        return this.listChildrenRecursively(webRoot, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return true;
            }
        });
    }

    public List<Resource<?>> getResources(ResourceFilter filter) {
        DirectoryResource webRoot = ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot, filter);
    }

    public DirectoryResource getWebInfDirectory() {
        return ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory().getChildDirectory("WEB-INF");
    }

    public List<Resource<?>> getResources() {
        DirectoryResource webRoot = ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource current, ResourceFilter filter) {
        ArrayList result = new ArrayList();
        List list = current.listResources();
        if (list != null) {
            for (Resource file : list) {
                if (file instanceof DirectoryResource) {
                    result.addAll(this.listChildrenRecursively((DirectoryResource)file, filter));
                }
                if (!filter.accept((Object)file)) continue;
                result.add(file);
            }
        }
        return result;
    }

    public void addLoginConfig(String authMethod, String realmName) {
        WebAppCommonDescriptor webXml = (WebAppCommonDescriptor)this.getConfig();
        webXml.getOrCreateLoginConfig().authMethod(authMethod).realmName(realmName);
        this.saveConfig(webXml);
    }

    public void addSecurityRole(String roleName) {
        WebAppCommonDescriptor webXml = (WebAppCommonDescriptor)this.getConfig();
        boolean exists = false;
        List allSecurityRole = webXml.getAllSecurityRole();
        for (SecurityRoleCommonType securityRoleCommonType : allSecurityRole) {
            if (!roleName.equals(securityRoleCommonType.getRoleName())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            webXml.createSecurityRole().roleName(roleName);
            this.saveConfig(webXml);
        }
    }

    public List<String> getSecurityRoles() {
        List securityRoles = ((WebAppCommonDescriptor)this.getConfig()).getAllSecurityRole();
        ArrayList<String> roleNames = new ArrayList<String>(securityRoles.size());
        for (SecurityRoleCommonType securityRole : securityRoles) {
            roleNames.add(securityRole.getRoleName());
        }
        return roleNames;
    }

    public boolean removeSecurityRole(String roleName) {
        boolean roleRemoved = false;
        WebAppCommonDescriptor webXml = (WebAppCommonDescriptor)this.getConfig();
        ArrayList initialRoles = new ArrayList(webXml.getAllSecurityRole());
        webXml.removeAllSecurityRole();
        for (SecurityRoleCommonType role : initialRoles) {
            if (!role.getRoleName().equals(roleName)) {
                webXml.createSecurityRole().roleName(role.getRoleName());
                continue;
            }
            roleRemoved = true;
        }
        this.saveConfig(webXml);
        return roleRemoved;
    }

    public void addSecurityConstraint(String displayName, String webResourceName, String webResourceDescription, Iterable<String> httpMethods, Iterable<String> urlPatterns, Iterable<String> securityRoles, TransportGuarantee transportGuarantee) {
        List securityRolesList;
        WebAppCommonDescriptor webXml = (WebAppCommonDescriptor)this.getConfig();
        SecurityConstraintCommonType securityConstraint = webXml.createSecurityConstraint();
        List httpMethodsList = Lists.toList(httpMethods);
        List urlPatternsList = Lists.toList(urlPatterns);
        if (displayName != null) {
            securityConstraint.displayName(new String[]{displayName});
        }
        WebResourceCollectionCommonType resourceCollection = securityConstraint.createWebResourceCollection();
        resourceCollection.webResourceName(webResourceName);
        if (webResourceDescription != null) {
            resourceCollection.description(new String[]{webResourceDescription});
        }
        if (!httpMethodsList.isEmpty()) {
            resourceCollection.httpMethod(httpMethodsList.toArray(new String[httpMethodsList.size()]));
        }
        if (!urlPatternsList.isEmpty()) {
            resourceCollection.urlPattern(urlPatternsList.toArray(new String[urlPatternsList.size()]));
        }
        if ((securityRolesList = Lists.toList(securityRoles)) != null) {
            AuthConstraintCommonType authConstraint = securityConstraint.getOrCreateAuthConstraint();
            authConstraint.roleName(securityRolesList.toArray(new String[securityRolesList.size()]));
        }
        if (transportGuarantee != null) {
            UserDataConstraintCommonType userDataConstraint = securityConstraint.getOrCreateUserDataConstraint();
            userDataConstraint.transportGuarantee(transportGuarantee.name());
        }
        this.saveConfig(webXml);
    }
}

