/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.servlet;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.javaee.Descriptors;
import org.jboss.forge.addon.javaee.servlet.AbstractServletFacet;
import org.jboss.forge.addon.javaee.servlet.ServletFacet_2_5;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.webapp25.WebAppDescriptor;

public class ServletFacetImpl_2_5
extends AbstractServletFacet<WebAppDescriptor>
implements ServletFacet_2_5 {
    private static final Dependency JAVAX_SERVLET_API = DependencyBuilder.create((String)"org.jboss.spec.javax.servlet:jboss-servlet-api_2.5_spec:1.0.1.Final").setScopeType("provided");

    @Inject
    public ServletFacetImpl_2_5(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    public boolean isInstalled() {
        return super.isInstalled() && this.getConfigFile().exists() && "2.5".equals(this.getConfig().getVersionAsString());
    }

    @Override
    public boolean install() {
        if (!this.getConfigFile().exists() && ((PackagingFacet)((Project)this.getFaceted()).getFacet(PackagingFacet.class)).getPackagingType().equalsIgnoreCase("war")) {
            this.saveConfig(this.getConfig());
        }
        return super.install();
    }

    public Version getSpecVersion() {
        return SingleVersion.valueOf((String)"2.5");
    }

    @Override
    protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions() {
        LinkedHashMap<Dependency, List<Dependency>> map = new LinkedHashMap<Dependency, List<Dependency>>();
        map.put(JAVAX_SERVLET_API, Arrays.asList(JAVAX_SERVLET_API, JAVAEE6, JAVAEE7));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppDescriptor getConfig() {
        WebAppDescriptor descriptor;
        FileResource<?> configFile = this.getConfigFile();
        if (configFile.exists()) {
            DescriptorImporter importer = Descriptors.importAs(WebAppDescriptor.class);
            InputStream inputStream = configFile.getResourceInputStream();
            try {
                descriptor = (WebAppDescriptor)importer.fromStream(inputStream);
            }
            finally {
                Streams.closeQuietly((Closeable)inputStream);
            }
        } else {
            descriptor = (WebAppDescriptor)Descriptors.create(WebAppDescriptor.class);
            String projectName = ((MetadataFacet)((Project)this.getFaceted()).getFacet(MetadataFacet.class)).getProjectName();
            WebAppDescriptor unit = (WebAppDescriptor)descriptor.version("2.5").displayName(new String[]{projectName}).createSessionConfig().sessionTimeout(Integer.valueOf(30)).up();
            unit.createMimeMapping().extension("ico").mimeType("image/x-icon");
            configFile.setContents(descriptor.exportAsString());
        }
        return descriptor;
    }

    public void saveConfig(WebAppDescriptor descriptor) {
        FileResource<?> configFile = this.getConfigFile();
        String output = descriptor.exportAsString();
        configFile.setContents(output);
    }
}

