/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.Descriptors;
import org.jboss.forge.addon.javaee.validation.ValidationFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.validationConfiguration11.ValidationConfigurationDescriptor;

public class ValidationFacetImpl
extends AbstractJavaEEFacet
implements ValidationFacet {
    private final Dependency JAVAX_VALIDATION_API = DependencyBuilder.create((String)"javax.validation:validation-api").setScopeType("provided");

    @Inject
    public ValidationFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    public String getSpecName() {
        return "Bean Validation";
    }

    @Override
    public boolean install() {
        FileResource<?> descriptor;
        if (!this.isInstalled() && !(descriptor = this.getConfigFile()).exists()) {
            this.createDefaultConfig(descriptor);
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        return this.getConfigFile().exists() && super.isInstalled();
    }

    public Version getSpecVersion() {
        return SingleVersion.valueOf((String)"1.0");
    }

    @Override
    protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions() {
        return Collections.singletonMap(this.JAVAX_VALIDATION_API, Arrays.asList(this.JAVAX_VALIDATION_API, JAVAEE7));
    }

    public ValidationConfigurationDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(ValidationConfigurationDescriptor.class);
        FileResource<?> configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.createDefaultConfig(configFile);
        }
        ValidationConfigurationDescriptor descriptor = (ValidationConfigurationDescriptor)importer.fromStream(configFile.getResourceInputStream());
        return descriptor;
    }

    public FileResource<?> getConfigFile() {
        ResourcesFacet resources = (ResourcesFacet)((Project)this.getFaceted()).getFacet(ResourcesFacet.class);
        return resources.getResource("META-INF" + File.separator + "validation.xml");
    }

    public void saveConfig(ValidationConfigurationDescriptor descriptor) {
        FileResource<?> fileResource = this.getConfigFile();
        fileResource.createNewFile();
        fileResource.setContents(descriptor.exportAsString());
    }

    private void createDefaultConfig(FileResource<?> descriptor) {
        ValidationConfigurationDescriptor descriptorContents = ((ValidationConfigurationDescriptor)Descriptors.create(ValidationConfigurationDescriptor.class)).version("1.1");
        descriptor.setContents(descriptorContents.exportAsString());
    }
}

