/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.websocket.ui;

import javax.inject.Inject;
import javax.websocket.server.ServerEndpoint;
import org.jboss.forge.addon.javaee.websocket.ui.AbstractWebsocketCommand;
import org.jboss.forge.addon.javaee.websocket.ui.WebSocketMethodType;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.text.Inflector;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class WebSocketNewServerEndpointCommand
extends AbstractWebsocketCommand<JavaClassSource> {
    @Inject
    @WithAttributes(label="uri")
    private UIInput<String> uri;
    @Inject
    @WithAttributes(label="Methods")
    private UISelectMany<WebSocketMethodType> methods;
    @Inject
    private Inflector inflector;

    @Override
    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("WebSocket: New Server Endpoint").description("Create a new WebSocket Server Endpoint");
    }

    protected String getType() {
        return "WebSocket Server Endpoint";
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        builder.add(this.uri).add(this.methods);
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource source) throws Exception {
        if (this.uri.hasValue()) {
            source.addAnnotation(ServerEndpoint.class).setStringValue("/" + (String)this.uri.getValue());
        } else {
            source.addAnnotation(ServerEndpoint.class).setStringValue("/" + this.inflector.lowerCamelCase(((String)this.getNamed().getValue()).replace("Endpoint", ""), new char[0]));
        }
        for (WebSocketMethodType method : this.methods.getValue()) {
            Class[] parameters;
            MethodSource wsMethod = ((MethodSource)((MethodSource)source.addMethod().setPublic()).setName(this.inflector.lowerCamelCase(method.getAnnotation().getSimpleName(), new char[0]))).setReturnTypeVoid().setBody("");
            wsMethod.addAnnotation(method.getAnnotation());
            for (Class parameter : parameters = method.getParameters()) {
                wsMethod.addParameter(parameter, this.inflector.lowerCamelCase(parameter.getSimpleName(), new char[0]));
            }
        }
        return source;
    }
}

