/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.websocket.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.javaee.websocket.WebSocketFacet;
import org.jboss.forge.addon.javaee.websocket.ui.WebSocketSetupWizard;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class WebSocketSetupWizardImpl
extends AbstractJavaEECommand
implements WebSocketSetupWizard {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="WebSocket Version", defaultValue="1.0")
    private UISelectOne<WebSocketFacet> webSocketVersion;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("WebSocket: Setup").description("Setup WebSocket API in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"WebSocket"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.webSocketVersion);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        WebSocketFacet facet = (WebSocketFacet)this.webSocketVersion.getValue();
        if (this.facetFactory.install((Faceted)this.getSelectedProject((UIContextProvider)context), (Facet)facet)) {
            return Results.success((String)String.format("WebSocket API %s has been installed.", facet.getSpecVersion()));
        }
        return Results.fail((String)String.format("Could not install WebSocket API %s", facet.getSpecVersion()));
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

