/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.dependencies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyMetadata;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;

public class DependencyMetadataImpl
implements DependencyMetadata {
    private final Dependency dependency;
    private final List<DependencyRepository> repositories;
    private final List<Dependency> managedDependencies;
    private final List<Dependency> dependencies;

    public DependencyMetadataImpl(Dependency query, ArtifactDescriptorResult descriptor) {
        this.dependency = query;
        this.repositories = new ArrayList<DependencyRepository>();
        for (RemoteRepository r : descriptor.getRepositories()) {
            this.repositories.add(new DependencyRepository(r.getId(), r.getUrl()));
        }
        this.managedDependencies = new ArrayList<Dependency>();
        for (org.eclipse.aether.graph.Dependency d : descriptor.getManagedDependencies()) {
            this.managedDependencies.add(this.convertToForge(d));
        }
        this.dependencies = new ArrayList<Dependency>();
        for (org.eclipse.aether.graph.Dependency d : descriptor.getDependencies()) {
            this.dependencies.add(this.convertToForge(d));
        }
    }

    private Dependency convertToForge(org.eclipse.aether.graph.Dependency d) {
        Artifact a = d.getArtifact();
        DependencyBuilder dep = DependencyBuilder.create().setArtifactId(a.getArtifactId()).setGroupId(a.getGroupId()).setVersion(a.getBaseVersion());
        return dep;
    }

    public String toString() {
        return "[dependency=" + this.dependency + ", repositories=" + this.repositories + ", managedDependencies=" + this.managedDependencies + ", dependencies=" + this.dependencies + "]";
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public List<Dependency> getManagedDependencies() {
        return this.managedDependencies;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<DependencyRepository> getRepositories() {
        return this.repositories;
    }
}

