/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.resources;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jboss.forge.addon.maven.resources.MavenDependencyResourceImpl;
import org.jboss.forge.addon.maven.resources.MavenPomResource;
import org.jboss.forge.addon.maven.resources.MavenProfileResourceImpl;
import org.jboss.forge.addon.maven.resources.MavenRepositoryResourceImpl;
import org.jboss.forge.addon.parser.xml.resources.XMLResourceImpl;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.util.Streams;

@Vetoed
public class MavenPomResourceImpl
extends XMLResourceImpl
implements MavenPomResource {
    private Model currentModel;

    public MavenPomResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    public Resource<?> getChild(String name) {
        List chidren = this.listResources();
        for (Resource child : chidren) {
            if (!child.getName().trim().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected List<Resource<?>> doListResources() {
        ArrayList children = new ArrayList();
        this.listDependencies(children);
        this.listProfiles(children);
        this.listRepositories(children);
        return children;
    }

    private void listRepositories(List<Resource<?>> children) {
        List repositories = this.getCurrentModel().getRepositories();
        for (Repository repository : repositories) {
            children.add((Resource<?>)new MavenRepositoryResourceImpl(this.getResourceFactory(), this.parent, repository));
        }
    }

    private void listDependencies(List<Resource<?>> children) {
        Model model = this.getCurrentModel();
        for (Dependency dep : model.getDependencies()) {
            children.add((Resource<?>)new MavenDependencyResourceImpl((Resource<?>)this, dep));
        }
    }

    private void listProfiles(List<Resource<?>> children) {
        Model model = this.getCurrentModel();
        List profiles = model.getProfiles();
        for (Profile profile : profiles) {
            children.add((Resource<?>)new MavenProfileResourceImpl(this.getResourceFactory(), (Resource<?>)this, profile));
        }
    }

    public Model getCurrentModel() {
        this.initialize();
        return this.currentModel;
    }

    public Resource<File> createFrom(File file) {
        return new MavenPomResourceImpl(this.resourceFactory, file);
    }

    private void initialize() {
        if (this.currentModel == null) {
            InputStream stream = null;
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                stream = this.getResourceInputStream();
                this.currentModel = reader.read(stream);
                this.currentModel.setPomFile(this.getUnderlyingResourceObject());
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    Streams.closeQuietly(stream);
                    throw throwable;
                }
            }
            Streams.closeQuietly((Closeable)stream);
        }
    }
}

