/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.archetype;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.Subset;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactoryRegistry;
import org.jboss.forge.addon.maven.archetype.URLArchetypeCatalogFactory;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;

@Singleton
public class ArchetypeCatalogFactoryRegistryImpl
implements ArchetypeCatalogFactoryRegistry {
    private Map<String, ArchetypeCatalogFactory> factories = new TreeMap<String, ArchetypeCatalogFactory>();
    private final Logger log = Logger.getLogger(this.getClass().getName());
    @Inject
    private Imported<ArchetypeCatalogFactory> services;
    @Inject
    @Subset(value="maven.archetypes")
    private Configuration archetypeConfiguration;

    @PostConstruct
    void initializeDefaultFactories() {
        Iterator keys = this.archetypeConfiguration.getKeys();
        while (keys.hasNext()) {
            String name = keys.next().toString();
            if (name.isEmpty()) continue;
            String url = this.archetypeConfiguration.getString(name);
            try {
                this.addArchetypeCatalogFactory(name, new URL(url));
            }
            catch (MalformedURLException e) {
                this.log.log(Level.SEVERE, "Malformed URL for " + name, e);
            }
        }
    }

    @PreDestroy
    void destroy() {
        this.factories.clear();
    }

    public void addArchetypeCatalogFactory(String name, URL catalogURL) {
        this.addArchetypeCatalogFactory(new URLArchetypeCatalogFactory(name, catalogURL));
    }

    public void addArchetypeCatalogFactory(String name, URL catalogURL, String defaultRepositoryName) {
        this.addArchetypeCatalogFactory(new URLArchetypeCatalogFactory(name, catalogURL, defaultRepositoryName));
    }

    public void addArchetypeCatalogFactory(ArchetypeCatalogFactory factory) {
        Assert.notNull((Object)factory, (String)"Cannot add a null Archetype Catalog Factory");
        Assert.notNull((Object)factory.getName(), (String)"Archetype Catalog Factory must have a name");
        this.factories.put(factory.getName(), factory);
    }

    public Iterable<ArchetypeCatalogFactory> getArchetypeCatalogFactories() {
        TreeMap<String, ArchetypeCatalogFactory> result = new TreeMap<String, ArchetypeCatalogFactory>();
        for (ArchetypeCatalogFactory factory : this.services) {
            result.put(factory.getName(), factory);
        }
        result.putAll(this.factories);
        return Collections.unmodifiableCollection(result.values());
    }

    public ArchetypeCatalogFactory getArchetypeCatalogFactory(String name) {
        ArchetypeCatalogFactory result = null;
        if (name != null) {
            for (ArchetypeCatalogFactory factory : this.getArchetypeCatalogFactories()) {
                if (!name.equals(factory.getName())) continue;
                return factory;
            }
        }
        return result;
    }

    public void removeArchetypeCatalogFactory(String name) {
        this.factories.remove(name);
    }

    public boolean hasArchetypeCatalogFactories() {
        return this.factories.size() > 0 || !this.services.isUnsatisfied();
    }
}

