/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.beans;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.addon.parser.java.beans.Property;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;

public class JavaClassIntrospector {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private JavaClass klass;
    private List<Method<JavaClass>> methods;
    private Map<String, Property> propertyCache = new HashMap<String, Property>();

    public JavaClassIntrospector(JavaClass klass) {
        this.klass = klass;
        this.methods = this.klass.getMethods();
        this.populatePropertyCache();
    }

    public List<Property> getProperties() {
        return new ArrayList<Property>(this.propertyCache.values());
    }

    private void populatePropertyCache() {
        this.locateProperties();
        for (Member member : this.klass.getMembers()) {
            Field field;
            if (member.isStatic()) continue;
            String memberName = member.getName();
            if (!(member instanceof Field) || !this.hasAccessor(field = (Field)member)) continue;
            this.createOrUpdateProperty(memberName, (Field<JavaClass>)field, null, null);
        }
    }

    private void locateProperties() {
        for (Method<JavaClass> method : this.methods) {
            String propertyName;
            if (method.isStatic()) continue;
            if (this.isAccessor(method)) {
                propertyName = this.propertyNameFromMethod(method);
                this.createOrUpdateProperty(propertyName, null, method, null);
                continue;
            }
            if (!this.isMutator(method)) continue;
            propertyName = this.propertyNameFromMethod(method);
            this.createOrUpdateProperty(propertyName, null, null, method);
        }
    }

    private String propertyNameFromMethod(Method<JavaClass> method) {
        String methodName = method.getName();
        String qualifiedReturnType = method.getQualifiedReturnType();
        if (methodName.startsWith(GET_PREFIX)) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith(IS_PREFIX) && (qualifiedReturnType.equals("boolean") || qualifiedReturnType.equals("java.lang.Boolean"))) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith(SET_PREFIX)) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    private Property createOrUpdateProperty(String name, Field<JavaClass> field, Method<JavaClass> accessor, Method<JavaClass> mutator) {
        Property property = this.propertyCache.get(name);
        if (property == null) {
            property = new Property(name);
            this.propertyCache.put(name, property);
        }
        if (field != null) {
            property.setActualField(field);
        }
        if (accessor != null) {
            property.setAccessor(accessor);
        }
        if (mutator != null) {
            property.setMutator(mutator);
        }
        return property;
    }

    private boolean hasAccessor(Field<?> field) {
        String fieldName = field.getName();
        Property property = this.propertyCache.get(fieldName);
        return property != null;
    }

    private boolean isAccessor(Method<JavaClass> method) {
        String methodName = method.getName();
        String qualifiedReturnType = method.getQualifiedReturnType();
        List parameters = method.getParameters();
        if (!method.isStatic() && methodName.startsWith(GET_PREFIX) && qualifiedReturnType != null && parameters.size() == 0) {
            return true;
        }
        return methodName.startsWith(IS_PREFIX) && (qualifiedReturnType.equals("boolean") || qualifiedReturnType.equals("java.lang.Boolean")) && parameters.size() == 0;
    }

    private boolean isMutator(Method<JavaClass> method) {
        String methodName = method.getName();
        String qualifiedReturnType = method.getQualifiedReturnType();
        List parameters = method.getParameters();
        return !method.isStatic() && methodName.startsWith(SET_PREFIX) && qualifiedReturnType == null && parameters.size() == 1;
    }
}

