/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.utils;

import java.io.File;
import org.jboss.forge.addon.parser.java.utils.JLSValidator;

public class Packages {
    public static String toFileSyntax(String pkg) {
        return pkg.replace(".", File.separator);
    }

    public static String fromFileSyntax(String pkg) {
        return pkg.replace(File.separator, ".");
    }

    public static String toValidPackageName(String pkg) {
        String[] tokens;
        if (pkg == null) {
            throw new IllegalArgumentException("Package should not be null");
        }
        StringBuilder sb = new StringBuilder(pkg.length());
        for (int i = 0; i < pkg.length(); ++i) {
            char c = pkg.charAt(i);
            if (c == '.' && (i == 0 || i == pkg.length() - 1) || c != '.' && !Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        String packageName = sb.toString();
        StringBuilder result = new StringBuilder();
        for (String token : tokens = packageName.split("[.]")) {
            if (JLSValidator.isReservedWord(token)) {
                token = token + "_";
            }
            result.append(token).append(".");
        }
        return result.substring(0, result.length() - 1);
    }
}

