/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.utils;

import java.io.File;
import org.jboss.forge.addon.parser.java.utils.JLSValidator;

public class Packages {
    public static String toFileSyntax(String pkg) {
        return pkg.replace(".", File.separator);
    }

    public static String fromFileSyntax(String pkg) {
        return pkg.replace(File.separator, ".");
    }

    public static String toValidPackageName(String pkg) {
        String[] tokens;
        if (pkg == null) {
            throw new IllegalArgumentException("Package should not be null");
        }
        StringBuilder sb = new StringBuilder(pkg.length());
        for (int i = 0; i < pkg.length(); ++i) {
            char c = pkg.charAt(i);
            if (c == '.' && (i == 0 || i == pkg.length() - 1) || c != '.' && !Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        String packageName = sb.toString();
        StringBuilder result = new StringBuilder();
        for (String token : tokens = packageName.split("[.]")) {
            if (result.length() > 0 && result.charAt(result.length() - 1) != '.') {
                result.append('.');
            }
            if (JLSValidator.isReservedWord(token)) {
                result.append(token).append('_');
                continue;
            }
            if (Packages.isNumber(token)) {
                if (result.length() <= 0) continue;
                result.deleteCharAt(result.length() - 1);
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    private static boolean isNumber(String token) {
        try {
            Integer.parseInt(token);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

