/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.beans;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.source.JavaSource;

public class ProjectOperations {
    public List<JavaResource> getProjectInterfaces(Project project) {
        ArrayList<JavaResource> classes = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaInterfaceSourceVisitor(classes));
        }
        return classes;
    }

    public List<JavaResource> getProjectClasses(Project project) {
        ArrayList<JavaResource> classes = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaClassSourceVisitor(classes));
        }
        return classes;
    }

    public List<JavaResource> getProjectAnnotations(Project project) {
        ArrayList<JavaResource> classes = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaAnnotationsSourceVisitor(classes));
        }
        return classes;
    }

    public List<JavaResource> getProjectEnums(Project project) {
        final ArrayList<JavaResource> enums = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                @Override
                public void visit(VisitContext context, JavaResource resource) {
                    try {
                        JavaSource javaSource = (JavaSource)resource.getJavaType();
                        if (javaSource.isEnum()) {
                            enums.add(resource);
                        }
                    }
                    catch (FileNotFoundException | ResourceException throwable) {
                        // empty catch block
                    }
                }
            });
        }
        return enums;
    }

    private static class JavaAnnotationsSourceVisitor
    extends JavaResourceVisitor {
        private final List<JavaResource> classes;

        private JavaAnnotationsSourceVisitor(List<JavaResource> classes) {
            this.classes = classes;
        }

        @Override
        public void visit(VisitContext context, JavaResource resource) {
            try {
                JavaSource javaType = (JavaSource)resource.getJavaType();
                if (javaType.isAnnotation()) {
                    this.classes.add(resource);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private static class JavaInterfaceSourceVisitor
    extends JavaResourceVisitor {
        private final List<JavaResource> classes;

        private JavaInterfaceSourceVisitor(List<JavaResource> classes) {
            this.classes = classes;
        }

        @Override
        public void visit(VisitContext context, JavaResource resource) {
            try {
                JavaSource javaType = (JavaSource)resource.getJavaType();
                if (javaType.isInterface()) {
                    this.classes.add(resource);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    private static class JavaClassSourceVisitor
    extends JavaResourceVisitor {
        private final List<JavaResource> classes;

        private JavaClassSourceVisitor(List<JavaResource> classes) {
            this.classes = classes;
        }

        @Override
        public void visit(VisitContext context, JavaResource resource) {
            try {
                JavaSource javaType = (JavaSource)resource.getJavaType();
                if (javaType.isClass()) {
                    this.classes.add(resource);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }
}

