/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.converters;

import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.furnace.util.Strings;

public class PackageRootConverter
implements Converter<String, String> {
    private final ProjectFactory projectFactory;
    private final UIContextProvider contextProvider;

    @Inject
    public PackageRootConverter(ProjectFactory projectFactory, UIContextProvider contextProvider) {
        this.projectFactory = projectFactory;
        this.contextProvider = contextProvider;
    }

    public String convert(String source) {
        String result;
        if (Strings.isNullOrEmpty((String)source) || this.contextProvider.getUIContext() == null) {
            result = source;
        } else {
            UIContext context = this.contextProvider.getUIContext();
            Project selectedProject = Projects.getSelectedProject((ProjectFactory)this.projectFactory, (UIContext)context);
            if (selectedProject != null && selectedProject.hasFacet(JavaSourceFacet.class)) {
                String fullPackage;
                String basePackage = ((JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class)).getBasePackage();
                result = fullPackage = source.replaceAll("\\~", basePackage);
            } else {
                result = source;
            }
        }
        return result;
    }
}

