/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.beans;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.roaster.model.source.JavaSource;

public class ProjectOperations {
    public List<JavaResource> getProjectClasses(Project project) {
        ArrayList<JavaResource> classes = new ArrayList<JavaResource>();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaClassSourceVisitor(classes));
        }
        return classes;
    }

    private static class JavaClassSourceVisitor
    extends JavaResourceVisitor {
        private final List<JavaResource> classes;

        private JavaClassSourceVisitor(List<JavaResource> classes) {
            this.classes = classes;
        }

        @Override
        public void visit(VisitContext context, JavaResource resource) {
            try {
                JavaSource javaType = (JavaSource)resource.getJavaType();
                if (javaType.isClass()) {
                    this.classes.add(resource);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }
}

