/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;

public abstract class AbstractJavaSourceCommand<SOURCETYPE extends JavaSource<?>>
extends AbstractProjectCommand {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    @WithAttributes(label="Package Name", type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Type Name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Overwrite", description="The overwrite flag that is used if the class already exists.", defaultValue="false")
    private UIInput<Boolean> overwrite;

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        final JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.named.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                if (!Types.isSimpleName((String)((String)AbstractJavaSourceCommand.this.named.getValue()))) {
                    context.addValidationError((InputComponent)AbstractJavaSourceCommand.this.named, "Invalid java type name.");
                }
            }
        });
        this.overwrite.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (AbstractJavaSourceCommand.this.named.getValue() == null) {
                    return false;
                }
                return AbstractJavaSourceCommand.this.classExists(javaSourceFacet);
            }
        });
        if (project.hasFacet(JavaSourceFacet.class)) {
            final TreeSet packageNames = new TreeSet();
            javaSourceFacet.visitJavaSources(new JavaResourceVisitor(){

                @Override
                public void visit(VisitContext context, JavaResource javaResource) {
                    String packageName = javaSourceFacet.calculatePackage(javaResource);
                    packageNames.add(packageName);
                }
            });
            this.targetPackage.setCompleter((UICompleter)new UICompleter<String>(){

                public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                    LinkedHashSet<String> result = new LinkedHashSet<String>();
                    for (String packageName : packageNames) {
                        if (!Strings.isNullOrEmpty((String)value) && !packageName.startsWith(value)) continue;
                        result.add(packageName);
                    }
                    return result;
                }
            });
        }
        this.targetPackage.setDefaultValue((Object)this.calculateDefaultPackage(builder.getUIContext()));
        builder.add(this.targetPackage).add(this.named).add(this.overwrite);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: New " + this.getType()).description("Creates a new Java " + this.getType()).category(Categories.create((String[])new String[]{"Java"}));
    }

    protected abstract String getType();

    protected abstract Class<SOURCETYPE> getSourceType();

    private boolean classExists(JavaSourceFacet javaSourceFacet) {
        boolean classAlreadyExists;
        SOURCETYPE source = this.buildJavaSource(javaSourceFacet);
        if (source == null) {
            return false;
        }
        try {
            JavaResource parsedJavaResource = javaSourceFacet.getJavaResource((JavaSource<?>)source);
            classAlreadyExists = parsedJavaResource.exists();
        }
        catch (FileNotFoundException | ResourceException ex) {
            classAlreadyExists = false;
        }
        return classAlreadyExists;
    }

    private SOURCETYPE buildJavaSource(JavaSourceFacet java) {
        if (this.named.getValue() == null) {
            return null;
        }
        JavaSource source = (JavaSource)Roaster.create(this.getSourceType()).setName((String)this.named.getValue());
        if (this.targetPackage.hasValue() || this.targetPackage.hasDefaultValue()) {
            source.setPackage((String)this.targetPackage.getValue());
        } else {
            source.setPackage(java.getBasePackage());
        }
        return (SOURCETYPE)source;
    }

    public void validate(UIValidationContext validator) {
        Project project = this.getSelectedProject((UIContextProvider)validator);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        if (this.classExists(javaSourceFacet) && this.overwrite.isEnabled() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            validator.addValidationError(this.named, this.getType() + " " + (String)this.targetPackage.getValue() + "." + (String)this.named.getValue() + " already exists. Use the --overwrite flag to allow the overwrite.");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        SOURCETYPE source = this.buildJavaSource(javaSourceFacet);
        if (source.hasSyntaxErrors()) {
            UIOutput output = uiContext.getProvider().getOutput();
            PrintStream err = output.err();
            err.println("Syntax Errors:");
            for (SyntaxError error : source.getSyntaxErrors()) {
                err.println(error);
            }
            err.println();
            return Results.fail((String)"Syntax Errors found. See above");
        }
        SOURCETYPE decorated = this.decorateSource(context, project, source);
        if (decorated != null) {
            source = decorated;
        }
        JavaResource javaResource = javaSourceFacet.saveJavaSource((JavaSource<?>)source);
        uiContext.setSelection((Object)javaResource);
        return Results.success((String)(this.getType() + " " + source.getQualifiedName() + " was created"));
    }

    public SOURCETYPE decorateSource(UIExecutionContext context, Project project, SOURCETYPE source) throws Exception {
        return source;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected UIInput<String> getTargetPackage() {
        return this.targetPackage;
    }

    protected UIInput<String> getNamed() {
        return this.named;
    }

    protected UIInput<Boolean> getOverwrite() {
        return this.overwrite;
    }

    protected String calculateDefaultPackage(UIContext context) {
        Project project = this.getSelectedProject(context);
        String packageName = project != null ? ((MetadataFacet)project.getFacet(MetadataFacet.class)).getTopLevelPackage() : null;
        return packageName;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

