/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraintType;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.converters.PackageRootConverter;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.parser.java.ui.JavaSourceDecorator;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Completers;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaInterface;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.source.ExtendableSource;
import org.jboss.forge.roaster.model.source.InterfaceCapableSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Types;

@FacetConstraints(value={@FacetConstraint(value={JavaSourceFacet.class}, type=FacetConstraintType.REQUIRED)})
public abstract class AbstractJavaSourceCommand<SOURCETYPE extends JavaSource<?>>
extends AbstractProjectCommand
implements JavaSourceDecorator<SOURCETYPE> {
    private UIInput<String> targetPackage;
    private UIInput<String> named;
    private UIInput<Boolean> overwrite;
    private UIInput<String> extendsType;
    private UIInputMany<String> implementsType;
    private JavaSourceDecorator<SOURCETYPE> delegate = this;

    public void setJavaSourceDecorator(JavaSourceDecorator<SOURCETYPE> delegate) {
        this.delegate = delegate;
    }

    public JavaSourceDecorator<SOURCETYPE> getJavaSourceDecorator() {
        return this.delegate;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.targetPackage = (UIInput)((UIInput)factory.createInput("targetPackage", String.class).setLabel("Package Name")).setDescription("The package name where this type will be created");
        ((HintsFacet)this.targetPackage.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_PACKAGE_PICKER");
        this.targetPackage.setValueConverter((Converter)new PackageRootConverter(this.getProjectFactory(), (UIContextProvider)builder));
        this.named = (UIInput)((UIInput)((UIInput)factory.createInput("named", String.class).setLabel("Type Name")).setRequired(true)).setDescription("The type name");
        this.overwrite = (UIInput)((UIInput)((UIInput)factory.createInput("overwrite", Boolean.class).setLabel("Overwrite")).setDescription("The overwrite flag that is used if the class already exists.")).setDefaultValue((Object)false);
        this.extendsType = (UIInput)((UIInput)((UIInput)factory.createInput("extends", String.class).setLabel("Extends")).setDescription("The type used in the extends keyword")).setEnabled(this.supportsExtends());
        ((HintsFacet)this.extendsType.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_CLASS_PICKER");
        boolean isInterface = this.getSourceType() == JavaInterfaceSource.class;
        this.implementsType = (UIInputMany)((UIInputMany)factory.createInputMany(isInterface ? "extends" : "implements", String.class).setLabel(isInterface ? "Extended Interfaces" : "Interfaces")).setEnabled(this.supportsImplements());
        ((HintsFacet)this.implementsType.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_CLASS_PICKER");
        Project project = this.getSelectedProject((UIContextProvider)builder);
        final JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.named.addValidator(context -> {
            if (!Types.isSimpleName((String)((String)this.named.getValue()))) {
                context.addValidationError(this.named, "Invalid java type name.");
            }
        });
        this.overwrite.setEnabled(() -> this.named.hasValue() && this.classExists(javaSourceFacet));
        if (project.hasFacet(JavaSourceFacet.class)) {
            final TreeSet packageNames = new TreeSet();
            javaSourceFacet.visitJavaSources(new JavaResourceVisitor(){

                @Override
                public void visit(VisitContext context, JavaResource javaResource) {
                    String packageName = javaSourceFacet.calculatePackage(javaResource);
                    packageNames.add(packageName);
                }
            });
            this.targetPackage.setCompleter(Completers.fromValues(packageNames));
        }
        this.targetPackage.setDefaultValue((Object)this.calculateDefaultPackage(builder.getUIContext()));
        builder.add(this.targetPackage).add(this.named);
        if (this.extendsType.isEnabled()) {
            List extendsList = this.getExtendsValueChoices(project).stream().map(JavaResource::getFullyQualifiedTypeName).filter(Objects::nonNull).collect(Collectors.toList());
            this.extendsType.setCompleter(Completers.fromValues(extendsList));
            builder.add(this.extendsType);
        }
        if (this.implementsType.isEnabled()) {
            List implementsList = this.getImplementsValueChoices(project).stream().map(JavaResource::getFullyQualifiedTypeName).filter(Objects::nonNull).collect(Collectors.toList());
            this.implementsType.setCompleter(Completers.fromValues(implementsList));
            builder.add(this.implementsType);
        }
        builder.add(this.overwrite);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(this.getClass()).name("Java: New " + this.getType()).description("Creates a new Java " + this.getType()).category(Categories.create((String[])new String[]{"Java"}));
    }

    protected abstract String getType();

    protected abstract Class<SOURCETYPE> getSourceType();

    protected Collection<JavaResource> getExtendsValueChoices(Project project) {
        AddonRegistry addonRegistry = Furnace.instance((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
        ProjectOperations projectOperations = (ProjectOperations)addonRegistry.getServices(ProjectOperations.class).get();
        return projectOperations.getProjectClasses(project);
    }

    protected Collection<JavaResource> getImplementsValueChoices(Project project) {
        AddonRegistry addonRegistry = Furnace.instance((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
        ProjectOperations projectOperations = (ProjectOperations)addonRegistry.getServices(ProjectOperations.class).get();
        return projectOperations.getProjectInterfaces(project);
    }

    protected boolean supportsExtends() {
        Class<SOURCETYPE> sourceType = this.getSourceType();
        return ExtendableSource.class.isAssignableFrom(sourceType);
    }

    protected boolean supportsImplements() {
        Class<SOURCETYPE> sourceType = this.getSourceType();
        return InterfaceCapableSource.class.isAssignableFrom(sourceType);
    }

    private boolean classExists(JavaSourceFacet javaSourceFacet) {
        boolean classAlreadyExists;
        if (!this.named.hasValue() && !this.named.hasDefaultValue()) {
            return false;
        }
        String packageName = this.targetPackage.hasValue() || this.targetPackage.hasDefaultValue() ? (String)this.targetPackage.getValue() : javaSourceFacet.getBasePackage();
        String source = packageName + "." + (String)this.named.getValue();
        try {
            JavaResource parsedJavaResource = javaSourceFacet.getJavaResource(source);
            classAlreadyExists = parsedJavaResource != null && parsedJavaResource.exists();
        }
        catch (Exception ex) {
            classAlreadyExists = false;
        }
        return classAlreadyExists;
    }

    private SOURCETYPE buildJavaSource(JavaSourceFacet javaFacet) {
        if (!this.named.hasValue() && !this.named.hasDefaultValue()) {
            return null;
        }
        JavaSource source = (JavaSource)Roaster.create(this.getSourceType()).setName((String)this.named.getValue());
        if (this.targetPackage.hasValue() || this.targetPackage.hasDefaultValue()) {
            source.setPackage((String)this.targetPackage.getValue());
        } else {
            source.setPackage(javaFacet.getBasePackage());
        }
        if (source instanceof ExtendableSource && this.extendsType.isEnabled() && this.extendsType.hasValue()) {
            ExtendableSource extendableSource = (ExtendableSource)source;
            this.extendSuperType(extendableSource, (String)this.extendsType.getValue(), javaFacet);
        }
        if (source instanceof InterfaceCapableSource && this.implementsType.isEnabled() && this.implementsType.hasValue()) {
            InterfaceCapableSource interfaceCapableSource = (InterfaceCapableSource)source;
            this.implementInterface(interfaceCapableSource, this.implementsType.getValue(), javaFacet);
        }
        return (SOURCETYPE)source;
    }

    protected void extendSuperType(ExtendableSource<?> source, String value, JavaSourceFacet facet) {
        JavaResource javaResource = facet.getJavaResource(value);
        try {
            Object type;
            if (javaResource != null && javaResource.exists() && (type = javaResource.getJavaType()).isClass()) {
                JavaClass javaClass = (JavaClass)type;
                source.extendSuperType(javaClass);
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        source.setSuperType(value);
    }

    protected void implementInterface(InterfaceCapableSource<?> source, Iterable<String> value, JavaSourceFacet facet) {
        for (String type : value) {
            JavaResource javaResource = facet.getJavaResource(type);
            try {
                Object javaType;
                if (javaResource != null && javaResource.exists() && (javaType = javaResource.getJavaType()).isInterface()) {
                    source.implementInterface((JavaInterface)javaType);
                    continue;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            source.addInterface(type);
        }
    }

    public void validate(UIValidationContext validator) {
        Project project = this.getSelectedProject((UIContextProvider)validator);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        if (this.classExists(javaSourceFacet) && this.overwrite.isEnabled() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            validator.addValidationError(this.named, this.getType() + " " + (String)this.targetPackage.getValue() + "." + (String)this.named.getValue() + " already exists. Use the --overwrite flag to allow the overwrite.");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        SOURCETYPE source = this.buildJavaSource(javaSourceFacet);
        if (source.hasSyntaxErrors()) {
            UIOutput output = uiContext.getProvider().getOutput();
            PrintStream err = output.err();
            err.println("Syntax Errors:");
            for (SyntaxError error : source.getSyntaxErrors()) {
                err.println(error);
            }
            err.println();
            return Results.fail((String)"Syntax Errors found. See above");
        }
        SOURCETYPE decorated = this.delegate.decorateSource(context, project, source);
        if (decorated != null) {
            source = decorated;
        }
        JavaResource javaResource = javaSourceFacet.saveJavaSource((JavaSource<?>)source);
        uiContext.setSelection((Object)javaResource);
        return Results.success((String)(this.getType() + " " + source.getQualifiedName() + " was created"));
    }

    @Override
    public SOURCETYPE decorateSource(UIExecutionContext context, Project project, SOURCETYPE source) throws Exception {
        return source;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected UIInput<String> getTargetPackage() {
        return this.targetPackage;
    }

    protected UIInput<String> getNamed() {
        return this.named;
    }

    protected UIInput<Boolean> getOverwrite() {
        return this.overwrite;
    }

    protected UIInput<String> getExtendsType() {
        return this.extendsType;
    }

    protected UIInputMany<String> getImplementsType() {
        return this.implementsType;
    }

    protected String calculateDefaultPackage(UIContext context) {
        Project project = this.getSelectedProject(context);
        String packageName = project != null ? ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage() : null;
        return packageName;
    }
}

