/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.spi.ProjectCache;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.furnace.util.Assert;

@Singleton
public class InMemoryProjectCache
implements ProjectCache {
    private Map<String, Project> projects = new ConcurrentHashMap<String, Project>();

    public Project get(DirectoryResource dir) {
        Assert.notNull((Object)dir, (String)"Directory Resource should not be null");
        return this.projects.get(dir.getFullyQualifiedName());
    }

    public void invalidate() {
        this.projects.clear();
    }

    public void store(Project project) {
        Assert.notNull((Object)project, (String)"Project should not be null");
        this.projects.put(project.getProjectRoot().getFullyQualifiedName(), project);
    }

    public void evict(Project project) {
        this.projects.remove(project.getProjectRoot().getFullyQualifiedName());
    }
}

