/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectAssociationProvider;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.projects.ProjectLocator;
import org.jboss.forge.addon.projects.spi.ProjectCache;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.events.ResourceEvent;
import org.jboss.forge.addon.resource.monitor.ResourceListener;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Predicate;

@Singleton
public class ProjectFactoryImpl
implements ProjectFactory {
    private static final Logger log = Logger.getLogger(ProjectFactoryImpl.class.getName());
    @Inject
    private AddonRegistry registry;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private FacetFactory factory;
    @Inject
    private Imported<ProjectListener> builtInListeners;
    @Inject
    private Imported<ProjectCache> caches;
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();

    public Project findProject(FileResource<?> target) {
        return this.findProject(target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project findProject(FileResource<?> target, Predicate<Project> filter) {
        if (filter == null) {
            filter = new Predicate<Project>(){

                public boolean accept(Project type) {
                    return true;
                }
            };
        }
        Project result = null;
        Imported instances = this.registry.getServices(ProjectLocator.class);
        for (ProjectLocator locator : instances) {
            try {
                DirectoryResource r;
                DirectoryResource directoryResource = r = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent();
                while (r != null && result == null) {
                    Iterator cacheIterator = this.caches.iterator();
                    while (cacheIterator.hasNext() && result == null) {
                        ProjectCache cache = (ProjectCache)cacheIterator.next();
                        try {
                            result = cache.get(r);
                            if (result != null && !filter.accept((Object)result)) {
                                result = null;
                            }
                            if (result == null) continue;
                            break;
                        }
                        finally {
                            this.caches.release((Object)cache);
                        }
                    }
                    if (result == null && locator.containsProject(r)) {
                        result = locator.createProject(r);
                        if (result != null && !filter.accept((Object)result)) {
                            result = null;
                        }
                        if (result != null) {
                            this.registerAvailableFacets(result);
                            this.cacheProject(result);
                        }
                    }
                    r = r.getParent();
                }
            }
            finally {
                instances.release((Object)locator);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public Project createProject(DirectoryResource projectDir) {
        return this.createProject(projectDir, null);
    }

    public Project createProject(DirectoryResource target, Iterable<Class<? extends ProjectFacet>> facetTypes) {
        DirectoryResource parentDir;
        ProjectLocator locator;
        Project result = null;
        Imported instances = this.registry.getServices(ProjectLocator.class);
        Iterator<Class<? extends ProjectFacet>> i$ = instances.iterator();
        while (i$.hasNext() && (result = (locator = (ProjectLocator)i$.next()).createProject(target)) == null) {
            instances.release((Object)locator);
        }
        if (result != null && (parentDir = (DirectoryResource)result.getProjectRoot().getParent().reify(DirectoryResource.class)) != null) {
            Imported locatorInstances = this.registry.getServices(ProjectAssociationProvider.class);
            for (ProjectAssociationProvider provider : locatorInstances) {
                if (provider.canAssociate(result, parentDir)) {
                    provider.associate(result, parentDir);
                }
                locatorInstances.release((Object)provider);
            }
        }
        if (result != null && facetTypes != null) {
            for (Class<? extends ProjectFacet> facetType : facetTypes) {
                try {
                    this.factory.install((Faceted)result, facetType);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Could not install " + Facet.class.getSimpleName() + " of type [" + facetType + "] into Project [" + result + "]");
                }
            }
        }
        if (result != null) {
            this.registerAvailableFacets(result);
        }
        if (result != null) {
            this.cacheProject(result);
            this.fireProjectCreated(result);
        }
        return result;
    }

    private void registerAvailableFacets(Project result) {
        for (Class type : this.registry.getExportedTypes(ProjectFacet.class)) {
            Iterable facets = this.factory.createFacets((Faceted)result, type);
            for (ProjectFacet facet : facets) {
                if (facet == null || !this.factory.register((Faceted)result, (Facet)facet)) continue;
                log.fine("Registered Facet [" + facet + "] into Project [" + result + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheProject(final Project project) {
        for (ProjectCache cache : this.caches) {
            try {
                cache.store(project);
            }
            finally {
                this.caches.release((Object)cache);
            }
        }
        final ResourceMonitor monitor = project.getProjectRoot().monitor();
        monitor.addResourceListener(new ResourceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processEvent(ResourceEvent event) {
                for (ProjectCache cache : ProjectFactoryImpl.this.caches) {
                    try {
                        cache.evict(project);
                    }
                    finally {
                        ProjectFactoryImpl.this.caches.release((Object)cache);
                    }
                }
                monitor.cancel();
            }
        });
    }

    private void fireProjectCreated(Project project) {
        for (ProjectListener listener : this.builtInListeners) {
            listener.projectCreated(project);
        }
        for (ProjectListener listener : this.projectListeners) {
            listener.projectCreated(project);
        }
    }

    public Project createTempProject() {
        return this.createTempProject(Collections.emptySet());
    }

    public Project createTempProject(Iterable<Class<? extends ProjectFacet>> facetTypes) {
        File rootDirectory = OperatingSystemUtils.createTempDir();
        DirectoryResource addonDir = (DirectoryResource)this.resourceFactory.create(DirectoryResource.class, (Object)rootDirectory);
        DirectoryResource projectDir = (DirectoryResource)addonDir.createTempResource();
        projectDir.deleteOnExit();
        Project project = this.createProject(projectDir, facetTypes);
        return project;
    }

    public ListenerRegistration<ProjectListener> addProjectListener(final ProjectListener listener) {
        this.projectListeners.add(listener);
        return new ListenerRegistration<ProjectListener>(){

            public ProjectListener removeListener() {
                ProjectFactoryImpl.this.projectListeners.remove(listener);
                return listener;
            }
        };
    }

    public boolean containsProject(DirectoryResource bound, FileResource<?> target) {
        Assert.notNull((Object)bound, (String)"Boundary should not be null");
        Assert.isTrue((boolean)this.isParent(bound, target), (String)"Target should be a child of bound");
        boolean result = false;
        DirectoryResource dir = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent();
        Imported instances = this.registry.getServices(ProjectLocator.class);
        for (ProjectLocator locator : instances) {
            for (DirectoryResource r = dir; r != null && !result; r = r.getParent()) {
                result = locator.containsProject(r);
                if (bound.equals(r)) break;
            }
            if (result) break;
            instances.release((Object)locator);
        }
        return result;
    }

    private boolean isParent(DirectoryResource dir, FileResource<?> child) {
        DirectoryResource childDir;
        DirectoryResource directoryResource = childDir = child instanceof DirectoryResource ? (DirectoryResource)child.reify(DirectoryResource.class) : child.getParent();
        while (childDir != null) {
            if (dir.equals(childDir)) {
                return true;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    public boolean containsProject(FileResource<?> target) {
        boolean result = false;
        DirectoryResource dir = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent();
        Imported instances = this.registry.getServices(ProjectLocator.class);
        for (ProjectLocator locator : instances) {
            for (DirectoryResource r = dir; r != null && !result; r = r.getParent()) {
                result = locator.containsProject(r);
            }
            if (result) break;
            instances.release((Object)locator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCaches() {
        for (ProjectCache cache : this.caches) {
            try {
                cache.invalidate();
            }
            finally {
                this.caches.release((Object)cache);
            }
        }
    }
}

