/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectAssociationProvider;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.projects.ProjectLocator;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.services.ExportedInstance;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Predicate;

@Singleton
public class ProjectFactoryImpl
implements ProjectFactory {
    private static final Logger log = Logger.getLogger(ProjectFactoryImpl.class.getName());
    @Inject
    private AddonRegistry registry;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private Furnace forge;
    @Inject
    private FacetFactory factory;
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();

    public Project findProject(FileResource<?> target) {
        return this.findProject(target, null);
    }

    public Project findProject(FileResource<?> target, Predicate<Project> filter) {
        if (filter == null) {
            filter = new Predicate<Project>(){

                public boolean accept(Project type) {
                    return true;
                }
            };
        }
        Project result = null;
        for (Object instance : this.registry.getExportedInstances(ProjectLocator.class)) {
            DirectoryResource r;
            DirectoryResource directoryResource = r = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent();
            while (r != null && result == null) {
                ProjectLocator locator = (ProjectLocator)instance.get();
                if (locator.containsProject(r) && !filter.accept((Object)(result = locator.createProject(r)))) {
                    result = null;
                }
                r = r.getParent();
            }
        }
        if (result != null) {
            for (Object instance : this.registry.getExportedTypes(ProjectFacet.class)) {
                ProjectFacet facet = (ProjectFacet)this.factory.create((Class)instance, result);
                if (facet == null || !facet.isInstalled() || !this.factory.install((Facet)facet, (Faceted)result)) continue;
                log.fine("Installed Facet [" + facet + "] into Project [" + result + "]");
            }
        }
        return result;
    }

    public Project createProject(DirectoryResource projectDir) {
        return this.createProject(projectDir, null);
    }

    public Project createProject(DirectoryResource target, Iterable<Class<? extends ProjectFacet>> facetTypes) {
        DirectoryResource parentDir;
        ExportedInstance exportedInstance;
        ProjectLocator locator;
        Project result = null;
        Iterator<Object> i$ = this.registry.getExportedInstances(ProjectLocator.class).iterator();
        while (i$.hasNext() && (result = (locator = (ProjectLocator)(exportedInstance = (ExportedInstance)i$.next()).get()).createProject(target)) == null) {
        }
        if (result != null && (parentDir = (DirectoryResource)result.getProjectRoot().getParent().reify(DirectoryResource.class)) != null) {
            for (ExportedInstance providerInstance : this.registry.getExportedInstances(ProjectAssociationProvider.class)) {
                ProjectAssociationProvider provider = (ProjectAssociationProvider)providerInstance.get();
                if (!provider.canAssociate(result, parentDir)) continue;
                provider.associate(result, parentDir);
            }
        }
        if (result != null && facetTypes != null) {
            for (Class clazz : facetTypes) {
                try {
                    this.factory.install(clazz, (Faceted)result);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Could not install " + Facet.class.getSimpleName() + " of type [" + clazz + "] into Project [" + result + "]");
                }
            }
        }
        if (result != null) {
            for (Class clazz : this.registry.getExportedTypes(ProjectFacet.class)) {
                ProjectFacet facet = (ProjectFacet)this.factory.create(clazz, (Faceted)result);
                if (facet == null || !facet.isInstalled() || !this.factory.install((Facet)facet, (Faceted)result)) continue;
                log.fine("Installed Facet [" + facet + "] into Project [" + result + "]");
            }
        }
        if (result != null) {
            this.fireProjectCreated(result);
        }
        return result;
    }

    private void fireProjectCreated(Project project) {
        for (ProjectListener listener : this.projectListeners) {
            listener.projectCreated(project);
        }
    }

    public Project createTempProject() {
        List repositories = this.forge.getRepositories();
        File rootDirectory = null;
        for (AddonRepository addonRepository : repositories) {
            if (!(addonRepository instanceof MutableAddonRepository)) continue;
            rootDirectory = addonRepository.getRootDirectory();
        }
        if (rootDirectory == null) {
            try {
                rootDirectory = File.createTempFile("forgeproject", ".tmp");
                rootDirectory.delete();
                rootDirectory.mkdirs();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create temp folder", e);
            }
        }
        DirectoryResource addonDir = (DirectoryResource)this.resourceFactory.create(DirectoryResource.class, (Object)rootDirectory);
        DirectoryResource projectDir = (DirectoryResource)addonDir.createTempResource();
        projectDir.deleteOnExit();
        Project project = this.createProject(projectDir);
        return project;
    }

    public ListenerRegistration<ProjectListener> addProjectListener(final ProjectListener listener) {
        this.projectListeners.add(listener);
        return new ListenerRegistration<ProjectListener>(){

            public ProjectListener removeListener() {
                ProjectFactoryImpl.this.projectListeners.remove(listener);
                return listener;
            }
        };
    }
}

