/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectType;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class NewProjectWizard
implements UIWizard {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Project name:", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Top level package:", required=true)
    private UIInput<String> topLevelPackage;
    @Inject
    @WithAttributes(label="Version:", required=false)
    private UIInput<String> version;
    @Inject
    @WithAttributes(label="Project location:")
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    @WithAttributes(label="Overwrite existing project location")
    private UIInput<Boolean> overwrite;
    @Inject
    @WithAttributes(label="Project Type:", required=true)
    private UISelectOne<ProjectType> type;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("New Project").description("Create a new project").category(Categories.create((String[])new String[]{"Project", "Generation"}));
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.version.setDefaultValue((Object)"1.0.0-SNAPSHOT");
        UISelection currentSelection = builder.getUIContext().getInitialSelection();
        if (!currentSelection.isEmpty()) {
            Resource resource = (Resource)currentSelection.get();
            if (resource instanceof DirectoryResource) {
                this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
            }
        } else {
            this.targetLocation.setDefaultValue((Object)this.resourceFactory.create(DirectoryResource.class, (Object)OperatingSystemUtils.getUserHomeDir()));
        }
        ((UIInput)this.overwrite.setDefaultValue((Object)false)).setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String projectName = (String)NewProjectWizard.this.named.getValue();
                return NewProjectWizard.this.targetLocation.getValue() != null && projectName != null && ((DirectoryResource)NewProjectWizard.this.targetLocation.getValue()).getChild(projectName).exists() && !((DirectoryResource)NewProjectWizard.this.targetLocation.getValue()).getChild(projectName).listResources().isEmpty();
            }
        });
        this.type.setItemLabelConverter((Converter)new Converter<ProjectType, String>(){

            public String convert(ProjectType source) {
                return source == null ? null : source.getType();
            }
        });
        ArrayList<ProjectType> projectTypes = new ArrayList<ProjectType>();
        for (ProjectType projectType : this.type.getValueChoices()) {
            projectTypes.add(projectType);
        }
        Collections.sort(projectTypes, new Comparator<ProjectType>(){

            @Override
            public int compare(ProjectType left, ProjectType right) {
                if (left == null || left.getType() == null || right == null || right.getType() == null) {
                    return 0;
                }
                return left.getType().compareTo(right.getType());
            }
        });
        if (!projectTypes.isEmpty()) {
            this.type.setDefaultValue(projectTypes.get(0));
        }
        this.type.setValueChoices(projectTypes);
        builder.add(this.named).add(this.topLevelPackage).add(this.version).add(this.targetLocation).add(this.overwrite).add(this.type);
    }

    public void validate(UIValidationContext context) {
        if (!((String)this.topLevelPackage.getValue()).matches("(?i)(~\\.)?([a-z0-9_]+\\.?)+[a-z0-9_]")) {
            context.addValidationError(this.topLevelPackage, "Top level package must be a valid package name.");
        }
        if (this.overwrite.isEnabled() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            context.addValidationError(this.targetLocation, "Target location is not empty.");
        }
    }

    public Result execute(UIContext context) throws Exception {
        Result result = Results.success((String)"New project has been created.");
        DirectoryResource directory = (DirectoryResource)this.targetLocation.getValue();
        DirectoryResource targetDir = directory.getChildDirectory((String)this.named.getValue());
        if (targetDir.mkdirs() || ((Boolean)this.overwrite.getValue()).booleanValue()) {
            ProjectType value = (ProjectType)this.type.getValue();
            Project project = null;
            project = value != null ? this.projectFactory.createProject(targetDir, value.getRequiredFacets()) : this.projectFactory.createProject(targetDir);
            if (project != null) {
                MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
                metadataFacet.setProjectName((String)this.named.getValue());
                metadataFacet.setProjectVersion((String)this.version.getValue());
                metadataFacet.setTopLevelPackage((String)this.topLevelPackage.getValue());
                context.setAttribute(Project.class, (Object)project);
            } else {
                result = Results.fail((String)("Could not create project of type: [" + value + "]"));
            }
        } else {
            result = Results.fail((String)("Could not create target location: " + targetDir));
        }
        return result;
    }

    public UIInput<String> getNamed() {
        return this.named;
    }

    public UIInput<DirectoryResource> getTargetLocation() {
        return this.targetLocation;
    }

    public UIInput<Boolean> getOverwrite() {
        return this.overwrite;
    }

    public UISelectOne<ProjectType> getType() {
        return this.type;
    }

    public SingleValued<UIInput<String>, String> getTopLevelPackage() {
        return this.topLevelPackage;
    }

    public NavigationResult next(UIContext context) throws Exception {
        if (this.type.getValue() != null) {
            return Results.navigateTo((Class)((ProjectType)this.type.getValue()).getSetupFlow());
        }
        return null;
    }
}

