/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.building.ProjectBuilder;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class BuildCommand
extends AbstractProjectCommand {
    @Inject
    @WithAttributes(label="Arguments")
    private UIInputMany<String> arguments;
    @Inject
    @WithAttributes(label="No Test")
    private UIInput<Boolean> notest;
    @Inject
    @WithAttributes(label="Profile")
    private UIInput<String> profile;
    @Inject
    private ProjectFactory projectFactory;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments).add(this.notest).add(this.profile);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Build").description("Build this project").category(Categories.create((String[])new String[]{"Project", "Build"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(UIExecutionContext context) throws Exception {
        UIOutput output = context.getUIContext().getProvider().getOutput();
        Project project = this.getSelectedProject((UIContextProvider)context);
        PackagingFacet packaging = (PackagingFacet)project.getFacet(PackagingFacet.class);
        ProjectBuilder builder = packaging.createBuilder();
        if (this.arguments.getValue() != null && this.arguments.getValue().iterator().hasNext()) {
            ArrayList<String> args = new ArrayList<String>();
            for (String val : this.arguments.getValue()) {
                args.add(val);
            }
            builder.addArguments(args.toArray(new String[args.size()]));
        } else {
            builder.addArguments(new String[]{"install"});
        }
        if (((Boolean)this.notest.getValue()).booleanValue()) {
            builder.runTests(false);
        }
        if (this.profile.getValue() != null) {
            builder.addArguments(new String[]{"-P" + (String)this.profile.getValue()});
        }
        try {
            builder.build(output.out(), output.err());
        }
        catch (BuildException e) {
            Result result = Results.fail((String)"Build failed.", (Throwable)e);
            return result;
        }
        finally {
            output.out().flush();
            output.err().flush();
        }
        return Results.success((String)"Build Success");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

