/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.spi.ProjectCache;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.furnace.util.Assert;

@Singleton
public class InMemoryProjectCache
implements ProjectCache {
    private final Map<String, WeakReference<Project>> projects = new ConcurrentHashMap<String, WeakReference<Project>>();

    public Project get(DirectoryResource dir) {
        Assert.notNull((Object)dir, (String)"Directory Resource should not be null");
        WeakReference<Project> ref = this.projects.get(dir.getFullyQualifiedName());
        Project project = null;
        if (ref != null) {
            project = (Project)ref.get();
        }
        return project;
    }

    public void invalidate() {
        this.projects.clear();
    }

    public void store(Project project) {
        Assert.notNull((Object)project, (String)"Project should not be null");
        this.projects.put(project.getProjectRoot().getFullyQualifiedName(), new WeakReference<Project>(project));
    }

    public void evict(Project project) {
        this.projects.remove(project.getProjectRoot().getFullyQualifiedName());
    }
}

