/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.BuildSystem;
import org.jboss.forge.addon.projects.BuildSystemFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectAssociationProvider;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectListener;
import org.jboss.forge.addon.projects.spi.ProjectCache;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.events.ResourceEvent;
import org.jboss.forge.addon.resource.monitor.ResourceListener;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Predicate;

@Singleton
public class ProjectFactoryImpl
implements ProjectFactory {
    private static final Logger log = Logger.getLogger(ProjectFactoryImpl.class.getName());
    @Inject
    private AddonRegistry registry;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private FacetFactory factory;
    @Inject
    private Imported<ProjectListener> builtInListeners;
    @Inject
    private Imported<ProjectCache> caches;
    private final List<ListenerRegistration<ResourceListener>> listeners = new ArrayList<ListenerRegistration<ResourceListener>>();
    private final Predicate<ProjectFacet> notBuildSystemFilter = new Predicate<ProjectFacet>(){

        public boolean accept(ProjectFacet type) {
            return !(type instanceof BuildSystemFacet);
        }
    };
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();
    private final Predicate<Project> acceptsAllProjects = new Predicate<Project>(){

        public boolean accept(Project type) {
            return true;
        }
    };

    void shutdown(@Observes @Local PreShutdown event) {
        this.invalidateCaches();
        for (ListenerRegistration<ResourceListener> registration : this.listeners) {
            registration.removeListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project findProject(FileResource<?> target) {
        Project result = null;
        Imported instances = this.registry.getServices(BuildSystem.class);
        for (BuildSystem buildSystem : instances) {
            try {
                result = this.findProject(target, buildSystem);
            }
            finally {
                instances.release((Object)buildSystem);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public Project findProject(FileResource<?> target, BuildSystem buildSystem) {
        return this.findProject(target, buildSystem, this.acceptsAllProjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project findProject(FileResource<?> target, Predicate<Project> filter) {
        if (filter == null) {
            filter = this.acceptsAllProjects;
        }
        Project result = null;
        Imported instances = this.registry.getServices(BuildSystem.class);
        for (BuildSystem buildSystem : instances) {
            try {
                result = this.findProject(target, buildSystem, filter);
            }
            finally {
                instances.release((Object)buildSystem);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project findProject(FileResource<?> target, BuildSystem buildSystem, Predicate<Project> filter) {
        DirectoryResource r;
        Assert.notNull(target, (String)"Target cannot be null");
        if (filter == null) {
            filter = this.acceptsAllProjects;
        }
        Project result = null;
        DirectoryResource directoryResource = r = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent();
        while (r != null && result == null) {
            Iterator cacheIterator = this.caches.iterator();
            while (cacheIterator.hasNext() && result == null) {
                ProjectCache cache = (ProjectCache)cacheIterator.next();
                try {
                    result = cache.get(r);
                    if (result != null && !filter.accept((Object)result)) {
                        result = null;
                    }
                    if (result == null) continue;
                    break;
                }
                finally {
                    this.caches.release((Object)cache);
                }
            }
            if (result == null && buildSystem.containsProject(r)) {
                result = buildSystem.createProject(r);
                if (result != null && !filter.accept((Object)result)) {
                    result = null;
                }
                if (result != null) {
                    this.registerAvailableFacets(result);
                    this.cacheProject(result);
                }
            }
            r = r.getParent();
        }
        return result;
    }

    public Project createProject(DirectoryResource projectDir, BuildSystem buildSystem) {
        return this.createProject(projectDir, buildSystem, null);
    }

    public Project createProject(DirectoryResource target, BuildSystem buildSystem, Iterable<Class<? extends ProjectFacet>> facetTypes) {
        DirectoryResource parentDir;
        Project result;
        Assert.notNull((Object)target, (String)"Target project directory must not be null.");
        Assert.notNull((Object)buildSystem, (String)"Build system type must not be null.");
        if (facetTypes != null) {
            Assert.isTrue((boolean)this.isBuildable(buildSystem, facetTypes), (String)("The provided build system [" + buildSystem.getType() + "] cannot create a project that requires facets of the following types: " + this.getMissingBuildSystemFacets(buildSystem, this.getRequiredBuildSystemFacets(facetTypes))));
        }
        if ((result = buildSystem.createProject(target)) != null && (parentDir = (DirectoryResource)result.getProjectRoot().getParent().reify(DirectoryResource.class)) != null) {
            Imported buildSystemInstances = this.registry.getServices(ProjectAssociationProvider.class);
            for (ProjectAssociationProvider provider : buildSystemInstances) {
                if (provider.canAssociate(result, parentDir)) {
                    provider.associate(result, parentDir);
                }
                buildSystemInstances.release((Object)provider);
            }
        }
        if (result != null && facetTypes != null) {
            for (Class<? extends ProjectFacet> facetType : facetTypes) {
                try {
                    ProjectFacet projectFacet;
                    if (BuildSystemFacet.class.isAssignableFrom(facetType)) continue;
                    Iterable facets = this.factory.createFacets((Faceted)result, facetType);
                    Iterator i$ = facets.iterator();
                    while (i$.hasNext() && !this.factory.install((Faceted)result, (Facet)(projectFacet = (ProjectFacet)i$.next()), this.notBuildSystemFilter)) {
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Could not install " + Facet.class.getSimpleName() + " of type [" + facetType + "] into Project [" + result + "]", e);
                }
            }
        }
        if (result != null) {
            this.registerAvailableFacets(result);
        }
        if (result != null) {
            this.cacheProject(result);
            this.fireProjectCreated(result);
        }
        return result;
    }

    private Iterable<Class<? extends BuildSystemFacet>> getMissingBuildSystemFacets(BuildSystem buildSystem, Iterable<Class<? extends BuildSystemFacet>> requiredFacets) {
        HashSet<Class<? extends BuildSystemFacet>> result = new HashSet<Class<? extends BuildSystemFacet>>();
        Iterable providedFacetTypes = buildSystem.getProvidedFacetTypes();
        if (requiredFacets != null && providedFacetTypes != null) {
            for (Class<? extends BuildSystemFacet> required : requiredFacets) {
                boolean found = false;
                for (Class provided : providedFacetTypes) {
                    if (!provided.isAssignableFrom(required)) continue;
                    found = true;
                }
                if (found) continue;
                result.add(required);
            }
        }
        return result;
    }

    private boolean isBuildable(BuildSystem buildSystem, Iterable<Class<? extends ProjectFacet>> facets) {
        boolean result = false;
        Iterable<Class<? extends BuildSystemFacet>> requiredFacets = this.getRequiredBuildSystemFacets(facets);
        result = requiredFacets == null ? true : !this.getMissingBuildSystemFacets(buildSystem, requiredFacets).iterator().hasNext();
        return result;
    }

    private Iterable<Class<? extends BuildSystemFacet>> getRequiredBuildSystemFacets(Iterable<Class<? extends ProjectFacet>> facets) {
        HashSet<Class<? extends BuildSystemFacet>> result = new HashSet<Class<? extends BuildSystemFacet>>();
        for (Class<? extends ProjectFacet> facetType : facets) {
            if (!BuildSystemFacet.class.isAssignableFrom(facetType)) continue;
            result.add(facetType);
        }
        return result;
    }

    private void registerAvailableFacets(Project result) {
        for (Class type : this.registry.getExportedTypes(ProjectFacet.class)) {
            Iterable facets = this.factory.createFacets((Faceted)result, type);
            for (ProjectFacet facet : facets) {
                if (facet == null || !this.factory.register((Faceted)result, (Facet)facet)) continue;
                log.fine("Registered Facet [" + facet + "] into Project [" + result + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheProject(final Project project) {
        for (ProjectCache cache : this.caches) {
            try {
                cache.store(project);
            }
            finally {
                this.caches.release((Object)cache);
            }
        }
        final ResourceMonitor monitor = project.getProjectRoot().monitor();
        ListenerRegistration registration = monitor.addResourceListener(new ResourceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processEvent(ResourceEvent event) {
                for (ProjectCache cache : ProjectFactoryImpl.this.caches) {
                    try {
                        cache.evict(project);
                    }
                    finally {
                        ProjectFactoryImpl.this.caches.release((Object)cache);
                    }
                }
                monitor.cancel();
            }
        });
        this.listeners.add((ListenerRegistration<ResourceListener>)registration);
    }

    private void fireProjectCreated(Project project) {
        for (ProjectListener listener : this.builtInListeners) {
            listener.projectCreated(project);
        }
        for (ProjectListener listener : this.projectListeners) {
            listener.projectCreated(project);
        }
    }

    public Project createTempProject() throws IllegalStateException {
        return this.createTempProject(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createTempProject(Iterable<Class<? extends ProjectFacet>> facetTypes) throws IllegalStateException {
        Imported buildSystems = this.registry.getServices(BuildSystem.class);
        if (buildSystems.isAmbiguous()) {
            throw new IllegalStateException("Cannot create generic temporary project in environment where multiple build systems are available. A single build system must be selected.");
        }
        BuildSystem buildSystem = (BuildSystem)buildSystems.get();
        try {
            Project project = this.createTempProject(buildSystem, facetTypes);
            return project;
        }
        finally {
            buildSystems.release((Object)buildSystem);
        }
    }

    public Project createTempProject(BuildSystem buildSystem) {
        return this.createTempProject(buildSystem, Collections.emptySet());
    }

    public Project createTempProject(BuildSystem buildSystem, Iterable<Class<? extends ProjectFacet>> facetTypes) {
        File rootDirectory = OperatingSystemUtils.createTempDir();
        DirectoryResource addonDir = (DirectoryResource)this.resourceFactory.create(DirectoryResource.class, (Object)rootDirectory);
        DirectoryResource projectDir = (DirectoryResource)addonDir.createTempResource();
        projectDir.deleteOnExit();
        Project project = this.createProject(projectDir, buildSystem, facetTypes);
        return project;
    }

    public ListenerRegistration<ProjectListener> addProjectListener(final ProjectListener listener) {
        Assert.notNull((Object)listener, (String)"Project listener must not be null.");
        this.projectListeners.add(listener);
        return new ListenerRegistration<ProjectListener>(){

            public ProjectListener removeListener() {
                ProjectFactoryImpl.this.projectListeners.remove(listener);
                return listener;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsProject(DirectoryResource bound, FileResource<?> target) {
        boolean found = false;
        Imported instances = this.registry.getServices(BuildSystem.class);
        for (BuildSystem buildSystem : instances) {
            try {
                found = this.containsProject(bound, target, buildSystem);
                if (!found) continue;
                break;
            }
            finally {
                instances.release((Object)buildSystem);
            }
        }
        return found;
    }

    public boolean containsProject(DirectoryResource bound, FileResource<?> target, BuildSystem buildSystem) {
        Assert.notNull((Object)bound, (String)"Boundary should not be null");
        Assert.isTrue((boolean)this.isParent(bound, target), (String)"Target should be a child of bound");
        DirectoryResource dir = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent();
        boolean found = false;
        for (DirectoryResource r = bound; r != null && !found; r = r.getParent()) {
            found = buildSystem.containsProject(r);
            if (dir.equals(r)) break;
        }
        return found;
    }

    private boolean isParent(DirectoryResource dir, FileResource<?> child) {
        DirectoryResource childDir;
        DirectoryResource directoryResource = childDir = child instanceof DirectoryResource ? (DirectoryResource)child.reify(DirectoryResource.class) : child.getParent();
        while (childDir != null) {
            if (dir.equals(childDir)) {
                return true;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsProject(FileResource<?> target) {
        boolean found = false;
        Imported instances = this.registry.getServices(BuildSystem.class);
        for (BuildSystem buildSystem : instances) {
            try {
                found = this.containsProject(target, buildSystem);
                if (!found) continue;
                break;
            }
            finally {
                instances.release((Object)buildSystem);
            }
        }
        return found;
    }

    public boolean containsProject(FileResource<?> target, BuildSystem buildSystem) {
        DirectoryResource dir;
        Assert.notNull(target, (String)"Target resource must not be null.");
        Assert.notNull((Object)buildSystem, (String)"Project build system must not be null.");
        boolean found = false;
        for (DirectoryResource r = dir = target instanceof DirectoryResource ? (DirectoryResource)target : target.getParent(); r != null && !found; r = r.getParent()) {
            found = buildSystem.containsProject(r);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCaches() {
        for (ProjectCache cache : this.caches) {
            try {
                cache.invalidate();
            }
            finally {
                this.caches.release((Object)cache);
            }
        }
    }
}

