/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.dependencies;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class AddDependenciesCommand
extends AbstractProjectCommand {
    @Inject
    private ProjectFactory factory;
    @Inject
    private DependencyInstaller installer;
    @Inject
    @WithAttributes(shortName=100, label="Coordinates", required=true, description="The coordinates of the arguments to be added [groupId :artifactId {:version :scope :packaging}]")
    private UIInputMany<Dependency> arguments;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(AddDependenciesCommand.class).description("Add one or more arguments to the current project.").name("Project: Add Dependencies").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (this.arguments.hasValue()) {
            int count = 0;
            for (Dependency gav : this.arguments.getValue()) {
                Dependency existingDep = deps.getEffectiveManagedDependency((Dependency)DependencyBuilder.create((Dependency)gav).setVersion(null));
                if (existingDep != null && context.getPrompt().promptBoolean(String.format("Dependency [%s:%s] is currently managed. Reference the existing managed dependency [%s:%s:%s]?", gav.getCoordinate().getArtifactId(), gav.getCoordinate().getGroupId(), existingDep.getCoordinate().getGroupId(), existingDep.getCoordinate().getArtifactId(), existingDep.getCoordinate().getVersion()))) {
                    gav = existingDep;
                }
                this.installer.install(project, gav);
                ++count;
            }
            return Results.success((String)("Installed [" + count + "] dependenc" + (count == 1 ? "y" : "ies") + "."));
        }
        return Results.fail((String)"No arguments specified.");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.factory;
    }
}

