/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.dependencies;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class RemoveManagedDependenciesCommand
extends AbstractProjectCommand {
    @Inject
    private ProjectFactory factory;
    @Inject
    @WithAttributes(shortName=100, label="Coordinates", required=true, description="The coordinates of the managed arguments to be removed [groupId :artifactId {:version :scope :packaging}]")
    private UISelectMany<Dependency> arguments;
    @Inject
    @WithAttributes(shortName=114, label="Remove un-managed arguments", defaultValue="false", required=false, description="Also remove any related arguments from the current project if they are now un-managed, if possible.")
    private UIInput<Boolean> removeUnmanaged;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(RemoveManagedDependenciesCommand.class).description("Remove one or more managed arguments from the current project.").name("Project: Remove Managed Dependencies").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        this.arguments.setValueChoices((Iterable)((DependencyFacet)project.getFacet(DependencyFacet.class)).getManagedDependencies());
        builder.add(this.arguments).add(this.removeUnmanaged);
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        if (this.arguments.hasValue()) {
            int count = 0;
            for (Dependency gav : this.arguments.getValue()) {
                deps.removeManagedDependency(gav);
                if (((Boolean)this.removeUnmanaged.getValue()).booleanValue() && !deps.hasEffectiveManagedDependency(gav)) {
                    deps.removeDependency(gav);
                }
                ++count;
            }
            return Results.success((String)("Removed [" + count + "] dependenc" + (count == 1 ? "y" : "ies") + "."));
        }
        return Results.fail((String)"No arguments specified.");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.factory;
    }
}

