/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui.repositories;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class RemoveRepositoryCommand
extends AbstractProjectCommand {
    @Inject
    private ProjectFactory factory;
    @Inject
    @WithAttributes(label="Repository URL", required=true, description="The repository URL")
    private UIInput<String> url;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(RemoveRepositoryCommand.class).description("Remove a repository configured in the current project descriptor.").name("Project: Remove Repository").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.url);
    }

    public Result execute(UIExecutionContext context) {
        String urlValue;
        Project project = this.getSelectedProject(context.getUIContext());
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        DependencyRepository rep = deps.removeRepository(urlValue = (String)this.url.getValue());
        Result result = rep != null ? Results.success((String)("Removed repository [" + rep.getId() + "->" + rep.getUrl() + "]")) : Results.fail((String)("No repository with url [" + urlValue + "]"));
        return result;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.factory;
    }
}

