/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.impl.facets;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;

@FacetConstraint(value={DependencyFacet.class})
public class ClassLoaderFacetImpl
extends AbstractFacet<Project>
implements ClassLoaderFacet {
    private static final Logger log = Logger.getLogger(ClassLoaderFacetImpl.class.getName());

    public boolean install() {
        return this.isInstalled();
    }

    public boolean isInstalled() {
        return true;
    }

    public URLClassLoader getClassLoader() {
        Object artifact;
        Project project = (Project)this.getFaceted();
        DependencyFacet facet = (DependencyFacet)project.getFacet(DependencyFacet.class);
        List effectiveDependencies = facet.getEffectiveDependencies();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Dependency dependency : effectiveDependencies) {
            artifact = dependency.getArtifact();
            if (artifact == null) continue;
            File artifactFile = (File)artifact.getUnderlyingResourceObject();
            try {
                urls.add(artifactFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warning("Error while configuring Reflections: " + e.getMessage());
            }
        }
        PackagingFacet packagingFacet = (PackagingFacet)project.getFacet(PackagingFacet.class);
        Resource finalArtifact = packagingFacet.getFinalArtifact();
        if (!finalArtifact.exists()) {
            finalArtifact = packagingFacet.createBuilder().quiet(true).build();
        }
        if (finalArtifact instanceof FileResource) {
            artifact = (File)((FileResource)finalArtifact).getUnderlyingResourceObject();
            try {
                urls.add(((File)artifact).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warning("Error while configuring Reflections: " + e.getMessage());
            }
        }
        URLClassLoader urlClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]));
        return urlClassLoader;
    }
}

