/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.io.PrintStream;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.building.BuildMessage;
import org.jboss.forge.addon.projects.building.BuildResult;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.ui.command.AbstractCommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

public class ProjectBuildStatusListener
extends AbstractCommandExecutionListener {
    public void postCommandExecuted(UICommand command, UIExecutionContext context, Result result) {
        PackagingFacet facet;
        BuildResult buildResult;
        UIContext uiContext;
        ProjectFactory projectFactory = (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
        Project project = Projects.getSelectedProject((ProjectFactory)projectFactory, (UISelection)(uiContext = context.getUIContext()).getSelection());
        if (project != null && project.hasFacet(PackagingFacet.class) && !(buildResult = (facet = (PackagingFacet)project.getFacet(PackagingFacet.class)).getBuildResult()).isSuccess()) {
            UIOutput output = uiContext.getProvider().getOutput();
            PrintStream err = output.err();
            output.error(err, String.format("Project '%s' has errors", project.getRoot()));
            block4: for (BuildMessage message : buildResult.getMessages()) {
                switch (message.getSeverity()) {
                    case ERROR: {
                        output.error(err, message.getMessage());
                        continue block4;
                    }
                    case WARN: {
                        output.warn(err, message.getMessage());
                        continue block4;
                    }
                }
                output.info(err, message.getMessage());
            }
        }
    }
}

