/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.shell.CommandNotFoundListener;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ShellFactory;
import org.jboss.forge.addon.shell.aesh.ForgeTerminal;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.command.AbstractCommandExecutionListener;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Streams;

public class RunCommand
extends AbstractShellCommand {
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Timeout (seconds)", defaultValue="500", required=false, description="Set the timeout after which this script should abort if execution has not completed.")
    private UIInput<Integer> timeout;
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER", required=false)
    private UIInputMany<String> arguments;
    @Inject
    @WithAttributes(label="Command", shortName=99, required=false)
    private UIInput<String> command;
    @Inject
    private ShellFactory shellFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("run").description("Execute/run a forge script file.");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.timeout).add(this.arguments).add(this.command);
    }

    public void validate(UIValidationContext validator) {
        if (!this.command.hasValue() && !this.arguments.hasValue()) {
            validator.addValidationError(null, "Command or script file must be provided");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(UIExecutionContext context) throws Exception {
        result = Results.fail((String)"Error executing script.");
        uiContext = context.getUIContext();
        currentResource = (Resource)uiContext.getInitialSelection().get();
        output = uiContext.getProvider().getOutput();
        if (this.command.hasValue()) {
            commands = ((String)this.command.getValue()).split(" ");
            processBuilder = new ProcessBuilder(commands);
            currentDir = currentResource.getUnderlyingResourceObject();
            if (currentDir instanceof File) {
                processBuilder.directory((File)currentDir);
            }
            process = processBuilder.start();
            executor = Executors.newFixedThreadPool(2);
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    Streams.write((InputStream)process.getInputStream(), (OutputStream)output.out());
                }
            });
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    Streams.write((InputStream)process.getErrorStream(), (OutputStream)output.err());
                }
            });
            executor.shutdown();
            returnCode = process.waitFor();
            if (returnCode != 0) return Results.fail((String)"Error while executing native command. See output for more details");
            return Results.success();
        }
        selectedResource = currentResource;
        block31: for (String path : this.arguments.getValue()) {
            resources = new ResourcePathResolver(this.resourceFactory, currentResource, path).resolve();
            for (Resource resource : resources) {
                block48: {
                    block46: {
                        block47: {
                            if (!resource.exists()) break block48;
                            stdin = new PipedOutputStream();
                            writer = new BufferedWriter(new OutputStreamWriter(stdin));
                            stdout = new UncloseablePrintStream(output.out());
                            stderr = new UncloseablePrintStream(output.err());
                            currentShell = (Shell)uiContext.getProvider();
                            terminalSize = currentShell.getConsole().getShell().getSize();
                            terminal = new ForgeTerminal(new org.jboss.forge.addon.shell.spi.Terminal(){

                                public void close() throws IOException {
                                }

                                public void initialize() {
                                }

                                public int getWidth() {
                                    return terminalSize.getWidth();
                                }

                                public int getHeight() {
                                    return terminalSize.getHeight();
                                }
                            });
                            settings = new SettingsBuilder().inputStream((InputStream)new PipedInputStream(stdin)).outputStream((PrintStream)stdout).outputStreamError((PrintStream)stderr).terminal((Terminal)terminal).create();
                            scriptShell = this.shellFactory.createShell(currentResource, settings);
                            var21_27 = null;
                            try {
                                block43: {
                                    block44: {
                                        block45: {
                                            scriptShell.getConsole().setPrompt(new Prompt(""));
                                            reader = new BufferedReader(new InputStreamReader(resource.getResourceInputStream()));
                                            var23_31 = null;
                                            try {
                                                startTime = System.currentTimeMillis();
lbl43:
                                                // 3 sources

                                                while (reader.ready()) {
                                                    try {
                                                        line = this.readLine(reader);
                                                        if (this.skipsLine(line)) continue;
                                                        timeoutValue = (Integer)this.timeout.getValue();
                                                        result = this.execute(scriptShell, writer, line, timeoutValue, TimeUnit.SECONDS, startTime);
                                                        if (result instanceof Failed) {
                                                            if (reader == null) break block43;
                                                            if (var23_31 == null) break block44;
                                                            break block45;
                                                        }
                                                        ** GOTO lbl-1000
                                                    }
                                                    catch (TimeoutException e) {
                                                        result = Results.fail((String)(path + ": timed out."));
                                                        if (reader != null) {
                                                            if (var23_31 != null) {
                                                                try {
                                                                    reader.close();
                                                                }
                                                                catch (Throwable x2) {
                                                                    var23_31.addSuppressed(x2);
                                                                }
                                                            } else {
                                                                reader.close();
                                                            }
                                                        }
                                                        if (scriptShell == null) break block31;
                                                        if (var21_27 != null) {
                                                            try {
                                                                scriptShell.close();
                                                            }
                                                            catch (Throwable x2) {
                                                                var21_27.addSuppressed(x2);
                                                            }
                                                            break block31;
                                                        }
                                                        scriptShell.close();
                                                        break block31;
                                                    }
                                                }
                                                break block46;
                                            }
                                            catch (Throwable var24_34) {
                                                try {
                                                    var23_31 = var24_34;
                                                    throw var24_34;
                                                }
                                                catch (Throwable var29_42) {
                                                    if (reader == null) throw var29_42;
                                                    if (var23_31 != null) {
                                                        try {
                                                            reader.close();
                                                            throw var29_42;
                                                        }
                                                        catch (Throwable x2) {
                                                            var23_31.addSuppressed(x2);
                                                            throw var29_42;
                                                        }
                                                    }
                                                    reader.close();
                                                    throw var29_42;
                                                }
                                            }
                                        }
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable x2) {
                                            var23_31.addSuppressed(x2);
                                        }
                                        break block43;
                                    }
                                    reader.close();
                                }
                                if (scriptShell == null) break block31;
                                if (var21_27 == null) break block47;
                            }
                            catch (Throwable var22_30) {
                                var21_27 = var22_30;
                                throw var22_30;
                            }
                            catch (Throwable var31_44) {
                                throw var31_44;
                            }
                            try {
                                scriptShell.close();
                            }
                            catch (Throwable x2) {
                                var21_27.addSuppressed(x2);
                            }
                            break block31;
                        }
                        scriptShell.close();
                        break block31;
lbl-1000:
                        // 1 sources

                        {
                            selectedResource = scriptShell.getCurrentResource();
                            ** GOTO lbl43
                        }
                    }
                    if (reader == null) continue;
                    if (var23_31 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            var23_31.addSuppressed(x2);
                        }
                        continue;
                    }
                    reader.close();
                    continue;
                }
                result = Results.fail((String)(path + ": not found."));
                break block31;
            }
        }
        if (result instanceof Failed != false) return result;
        uiContext.setSelection((Object)selectedResource);
        return result;
    }

    private String readLine(BufferedReader reader) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).endsWith("\\")) {
                result.append(line.substring(0, line.lastIndexOf("\\"))).append(' ');
                continue;
            }
            result.append(line);
            break;
        }
        return result.toString();
    }

    public Result execute(Shell shell, BufferedWriter stdin, String line, int quantity, TimeUnit unit, long startTime) throws TimeoutException {
        Assert.notNull((Object)line, (String)"Line to execute cannot be null.");
        if (this.skipsLine(line)) {
            return Results.success();
        }
        Result result = null;
        if (!line.trim().isEmpty()) {
            if (!line.endsWith(OperatingSystemUtils.getLineSeparator())) {
                line = line + OperatingSystemUtils.getLineSeparator();
            }
            ScriptCommandListener listener = new ScriptCommandListener();
            ListenerRegistration listenerRegistration = shell.addCommandExecutionListener((CommandExecutionListener)listener);
            ListenerRegistration notFoundRegistration = shell.addCommandNotFoundListener((CommandNotFoundListener)listener);
            try {
                stdin.write(line);
                stdin.flush();
                while (!listener.isExecuted()) {
                    if (System.currentTimeMillis() > startTime + TimeUnit.MILLISECONDS.convert(quantity, unit)) {
                        throw new TimeoutException("Timeout expired waiting for command [" + line + "] to execute.");
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new ContainerException("Command [" + line + "] did not respond.", (Throwable)e);
                    }
                }
                result = listener.getResult();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute command.", e);
            }
            finally {
                listenerRegistration.removeListener();
                notFoundRegistration.removeListener();
            }
        }
        return result;
    }

    private boolean skipsLine(String line) {
        return line.startsWith("#") || line.trim().isEmpty();
    }

    private static class UncloseablePrintStream
    extends PrintStream {
        public UncloseablePrintStream(PrintStream stream) {
            super(stream, true);
        }

        @Override
        public void close() {
        }
    }

    public class ScriptCommandListener
    extends AbstractCommandExecutionListener
    implements CommandNotFoundListener {
        Result result;

        public void preCommandExecuted(UICommand command, UIExecutionContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCommandExecuted(UICommand command, UIExecutionContext context, Result result) {
            ScriptCommandListener scriptCommandListener = this;
            synchronized (scriptCommandListener) {
                this.result = result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCommandFailure(UICommand command, UIExecutionContext context, Throwable failure) {
            ScriptCommandListener scriptCommandListener = this;
            synchronized (scriptCommandListener) {
                this.result = Results.fail((String)"Error encountered during command execution.", (Throwable)failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCommandNotFound(String line, UIContext context) {
            ScriptCommandListener scriptCommandListener = this;
            synchronized (scriptCommandListener) {
                this.result = Results.fail((String)("Command not found: " + line));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isExecuted() {
            ScriptCommandListener scriptCommandListener = this;
            synchronized (scriptCommandListener) {
                return this.result != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result getResult() {
            ScriptCommandListener scriptCommandListener = this;
            synchronized (scriptCommandListener) {
                return this.result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            ScriptCommandListener scriptCommandListener = this;
            synchronized (scriptCommandListener) {
                this.result = null;
            }
        }
    }
}

