/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command.transaction;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.transaction.ResourceTransactionListener;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.command.transaction.AggregateChangesTransactionListener;
import org.jboss.forge.addon.shell.command.transaction.AutomaticTransactionCommandListener;
import org.jboss.forge.addon.shell.command.transaction.OtherTransactionStartedListener;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.spi.ListenerRegistration;

@Singleton
public class TrackChangesSettings {
    private boolean trackChanges;
    @Inject
    private ResourceFactory factory;
    private final List<ListenerRegistration<?>> registrations = new ArrayList();
    private final OtherTransactionStartedListener otherTransactionListener = new OtherTransactionStartedListener();
    private ListenerRegistration<ResourceTransactionListener> otherTransactionListenerRegistration;

    protected void init(@Observes @Local PostStartup event) {
        this.otherTransactionListenerRegistration = this.factory.addTransactionListener((ResourceTransactionListener)this.otherTransactionListener);
    }

    protected void init(@Observes @Local PreShutdown event) {
        if (this.otherTransactionListenerRegistration != null) {
            this.otherTransactionListenerRegistration.removeListener();
        }
        for (ListenerRegistration<?> registration : this.registrations) {
            registration.removeListener();
        }
    }

    public boolean isTrackChanges() {
        return this.trackChanges;
    }

    public void setTrackChanges(Shell shell, boolean trackChanges) {
        this.trackChanges = trackChanges;
        if (trackChanges) {
            AggregateChangesTransactionListener aggregateChangeTxListener = new AggregateChangesTransactionListener();
            AutomaticTransactionCommandListener commandListener = new AutomaticTransactionCommandListener(this.factory, this.otherTransactionListener, aggregateChangeTxListener);
            this.registrations.add(shell.addCommandExecutionListener((CommandExecutionListener)commandListener));
            this.registrations.add(this.factory.addTransactionListener((ResourceTransactionListener)aggregateChangeTxListener));
        } else {
            for (ListenerRegistration<?> registration : this.registrations) {
                registration.removeListener();
            }
            this.registrations.clear();
        }
    }

    public boolean isInForeignTransaction() {
        return this.otherTransactionListener.isInForeignTransaction();
    }
}

