/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ShellFactory;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.ForgeTerminal;
import org.jboss.forge.addon.shell.spi.ShellHandle;
import org.jboss.forge.addon.shell.spi.ShellHandleSettings;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;

public class ShellHandleImpl
implements ShellHandle {
    @Inject
    private ShellFactory shellFactory;
    private Shell shell;

    public void initialize(ShellHandleSettings settings) {
        SettingsBuilder settingsBuilder = new SettingsBuilder().inputStream(settings.stdIn()).outputStream(settings.stdOut()).outputStreamError(settings.stdErr()).enableMan(true);
        if (settings.terminal() != null) {
            settingsBuilder.terminal((Terminal)new ForgeTerminal(settings.terminal()));
        }
        this.shell = this.shellFactory.createShell(settings.currentResource(), settingsBuilder.create());
        if (settings.desktop() != null) {
            ((ShellImpl)this.shell).setDesktop(settings.desktop());
        }
    }

    public void destroy() {
        if (this.shell != null) {
            try {
                this.shell.close();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Error while closing Shell", e);
            }
        }
    }

    public void addCommandExecutionListener(CommandExecutionListener listener) {
        if (this.shell != null) {
            this.shell.addCommandExecutionListener(listener);
        }
    }
}

