/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.CommandLineUtil;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.shell.ui.ShellUIPromptImpl;
import org.jboss.forge.addon.shell.util.ShellUtil;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;

public abstract class AbstractShellInteraction
implements Comparable<AbstractShellInteraction> {
    protected static final String INTERACTIVE_MODE_MESSAGE = "Required inputs not satisfied, entering interactive mode";
    protected static final String NON_INTERACTIVE_MODE_MESSAGE = "Required inputs not satisfied and INTERACTIVE=false, aborting. Please 'export INTERACTIVE=true' or try again providing the required values.";
    private final String name;
    private final CommandController controller;
    private final UICommandMetadata metadata;
    protected final CommandLineUtil commandLineUtil;
    private final ShellContext context;

    protected AbstractShellInteraction(CommandController controller, ShellContext shellContext, CommandLineUtil commandLineUtil) {
        this.context = shellContext;
        this.controller = controller;
        this.metadata = controller.getMetadata();
        this.name = ShellUtil.shellifyCommandName(this.metadata.getName());
        this.commandLineUtil = commandLineUtil;
    }

    protected abstract CommandLineParser getParser(ShellContext var1, String var2) throws Exception;

    protected abstract boolean promptRequiredMissingValues(ShellImpl var1) throws InterruptedException;

    protected ShellContext getContext() {
        return this.context;
    }

    protected CommandController getController() {
        return this.controller;
    }

    protected final String getName() {
        return this.name;
    }

    @Override
    public int compareTo(AbstractShellInteraction o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractShellInteraction)) {
            return false;
        }
        AbstractShellInteraction that = (AbstractShellInteraction)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected boolean hasMissingRequiredInputValues(Iterable<InputComponent<?, ?>> inputs) {
        for (InputComponent<?, ?> input : inputs) {
            if (!input.isEnabled() || !((HintsFacet)input.getFacet(HintsFacet.class)).isPromptInInteractiveMode()) continue;
            return true;
        }
        return false;
    }

    protected void promptRequiredMissingValues(ShellImpl shell, Iterable<InputComponent<?, ?>> inputs) throws InterruptedException {
        ShellUIPromptImpl prompt = shell.createPrompt((UIContext)this.context);
        for (InputComponent<?, ?> input : inputs) {
            boolean requiredInputMissing;
            if (!input.isEnabled()) continue;
            boolean bl = requiredInputMissing = input.isRequired() && !input.hasDefaultValue() && !input.hasValue();
            Object obj = prompt.promptValueFrom(input);
            if (obj != null || !requiredInputMissing) continue;
            break;
        }
    }
}

