/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh.completion;

import java.util.ArrayList;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.util.InputComponents;

class SelectComponentOptionCompleter
implements OptionCompleter<CompleterInvocation> {
    private final SelectComponent<?, Object> selectComponent;
    private final ConverterFactory converterFactory;

    public SelectComponentOptionCompleter(SelectComponent<?, Object> selectComponent, ConverterFactory converterFactory) {
        this.selectComponent = selectComponent;
        this.converterFactory = converterFactory;
    }

    public void complete(CompleterInvocation completerData) {
        Object value;
        String completeValue = completerData.getGivenCompleteValue();
        Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)this.converterFactory, this.selectComponent);
        Iterable valueChoices = this.selectComponent.getValueChoices();
        ArrayList<String> choices = new ArrayList<String>();
        for (Object choice : valueChoices) {
            String convert = (String)itemLabelConverter.convert(choice);
            if (convert == null || completeValue != null && !convert.startsWith(completeValue)) continue;
            choices.add(convert);
        }
        if (this.selectComponent instanceof ManyValued && (value = InputComponents.getValueFor(this.selectComponent)) != null) {
            if (value instanceof Iterable) {
                for (Object next : (Iterable)value) {
                    String convert = (String)itemLabelConverter.convert(next);
                    choices.remove(convert);
                }
            } else {
                String convert = (String)itemLabelConverter.convert(value);
                choices.remove(convert);
            }
        }
        completerData.addAllCompleterValues(choices);
    }
}

