/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import java.io.PrintStream;
import org.jboss.forge.addon.shell.ShellMessages;
import org.jboss.forge.addon.ui.progress.DefaultUIProgressMonitor;

public class ShellUIProgressMonitor
extends DefaultUIProgressMonitor {
    private final PrintStream out;

    public ShellUIProgressMonitor(PrintStream out) {
        this.out = out;
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        String message = String.format("%s \t[%d/%d] ...", name, this.getCurrentWork() + 1, this.getTotalWork());
        ShellMessages.info(this.out, message);
    }

    public void subTask(String name) {
        super.subTask(name);
        String message = String.format("%s:%s \t[%d/%d] ...", this.getTaskName(), name, this.getCurrentWork() + 1, this.getTotalWork());
        ShellMessages.info(this.out, message);
    }

    public void setTaskName(String name) {
        super.setTaskName(name);
        String message = String.format("%s \t[%d/%d] ...", name, this.getCurrentWork() + 1, this.getTotalWork());
        ShellMessages.info(this.out, message);
    }
}

