/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.activation.OptionActivator;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.parser.OptionParserException;
import org.jboss.aesh.cl.renderer.OptionRenderer;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.shell.aesh.CommandAdapter;
import org.jboss.forge.addon.shell.aesh.ForgeCommandLineParser;
import org.jboss.forge.addon.shell.aesh.ForgeResultHandler;
import org.jboss.forge.addon.shell.aesh.OptionRenderers;
import org.jboss.forge.addon.shell.aesh.completion.OptionCompleterFactory;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.shell.util.ShellUtil;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.addons.AddonRegistry;

class CommandLineUtil {
    private static final Logger logger = Logger.getLogger(CommandLineUtil.class.getName());
    private static final String ARGUMENTS_INPUT_NAME = "arguments";
    private final ConverterFactory converterFactory;

    public CommandLineUtil(AddonRegistry addonRegistry) {
        this.converterFactory = (ConverterFactory)addonRegistry.getServices(ConverterFactory.class).get();
    }

    public CommandLineParser generateParser(CommandAdapter command, CommandController commandController, ShellContext shellContext, Map<String, InputComponent<?, ?>> inputs) {
        ProcessedCommand processedCommand = this.generateCommand(command, commandController, shellContext, inputs);
        return new ForgeCommandLineParser(processedCommand, this, inputs, shellContext);
    }

    private ProcessedCommand generateCommand(CommandAdapter commandAdapter, CommandController commandController, ShellContext shellContext, Map<String, InputComponent<?, ?>> inputs) {
        UICommandMetadata metadata = commandController instanceof WizardCommandController ? ((WizardCommandController)commandController).getInitialMetadata() : commandController.getMetadata();
        String cmdName = ShellUtil.shellifyCommandName(metadata.getName());
        String cmdDescription = metadata.getDescription();
        ProcessedCommandBuilder commandBuilder = new ProcessedCommandBuilder().command((Command)commandAdapter).name(cmdName).description(cmdDescription).resultHandler((ResultHandler)new ForgeResultHandler(shellContext, cmdName));
        for (Map.Entry<String, InputComponent<?, ?>> entry : inputs.entrySet()) {
            String inputName = entry.getKey();
            final InputComponent<?, ?> input = entry.getValue();
            Object defaultValue = InputComponents.getValueFor(input);
            boolean isMultiple = input instanceof ManyValued;
            boolean hasValue = !"org.jboss.forge.inputType.CHECKBOX".equals(InputComponents.getInputType(input)) && !Boolean.class.isAssignableFrom(input.getValueType()) && !Boolean.TYPE.isAssignableFrom(input.getValueType());
            try {
                ProcessedOptionBuilder optionBuilder = new ProcessedOptionBuilder();
                optionBuilder.name(ShellUtil.shellifyOptionName(inputName)).addDefaultValue(defaultValue == null ? null : defaultValue.toString()).description(input.getLabel()).hasMultipleValues(isMultiple).hasValue(hasValue).type(input.getValueType());
                if (input.isRequired() && !input.hasDefaultValue() && !input.hasValue()) {
                    optionBuilder.renderer((OptionRenderer)OptionRenderers.REQUIRED);
                }
                OptionCompleter<CompleterInvocation> completer = OptionCompleterFactory.getCompletionFor(input, shellContext, this.converterFactory);
                optionBuilder.completer(completer);
                optionBuilder.activator(new OptionActivator(){

                    public boolean isActivated(ProcessedCommand processedCommand) {
                        return input.isEnabled();
                    }
                }).valueSeparator(' ');
                if (input.getShortName() != ' ') {
                    optionBuilder.shortName(input.getShortName());
                }
                ProcessedOption option = optionBuilder.create();
                if (ARGUMENTS_INPUT_NAME.equals(input.getName())) {
                    commandBuilder.argument(option);
                    continue;
                }
                commandBuilder.addOption(option);
            }
            catch (OptionParserException e) {
                logger.log(Level.SEVERE, "Error while parsing command option", e);
            }
        }
        try {
            return commandBuilder.create();
        }
        catch (CommandLineParserException e) {
            throw new RuntimeException("Error while parsing command: " + e.getMessage(), e);
        }
    }

    public Map<String, InputComponent<?, ?>> populateUIInputs(CommandLine commandLine, Map<String, InputComponent<?, ?>> inputs, UIContext context) {
        LinkedHashMap populatedInputs = new LinkedHashMap();
        for (Map.Entry<String, InputComponent<?, ?>> entry : inputs.entrySet()) {
            String name = ShellUtil.shellifyOptionName(entry.getKey());
            InputComponent<?, ?> input = entry.getValue();
            if (ARGUMENTS_INPUT_NAME.equals(name)) {
                InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, (Object)commandLine.getArgument().getValues());
                populatedInputs.put(name, input);
            }
            if (!commandLine.hasOption(name)) continue;
            Resource initialResource = (Resource)context.getInitialSelection().get();
            if (input instanceof ManyValued) {
                List<String> resolvedOptionValues = this.resolveWildcardSelectOptionValues(commandLine, name, input);
                if (Resource.class.isAssignableFrom(input.getValueType())) {
                    ArrayList resources = new ArrayList();
                    for (String optionValue : resolvedOptionValues) {
                        List resolved = Collections.emptyList();
                        try {
                            resolved = initialResource.resolveChildren(optionValue);
                        }
                        catch (RuntimeException re) {
                            logger.log(Level.FINER, "Error while resolving option value '" + optionValue + "' for " + initialResource, re);
                        }
                        resources.addAll(resolved);
                    }
                    if (resources.size() > 0) {
                        InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, resources);
                    } else {
                        InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, resolvedOptionValues);
                    }
                } else {
                    InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, resolvedOptionValues);
                }
                populatedInputs.put(name, input);
                continue;
            }
            if (!(input instanceof SingleValued)) continue;
            String optionValue = commandLine.getOptionValue(name);
            if (Resource.class.isAssignableFrom(input.getValueType())) {
                List resolved = Collections.emptyList();
                try {
                    resolved = initialResource.resolveChildren(optionValue);
                }
                catch (RuntimeException re) {
                    logger.log(Level.FINER, "Error while resolving option value '" + optionValue + "' for " + initialResource, re);
                }
                if (resolved.size() > 0) {
                    InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, resolved.get(0));
                } else {
                    InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, (Object)optionValue);
                }
            } else {
                InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, (Object)optionValue);
            }
            populatedInputs.put(name, input);
        }
        return populatedInputs;
    }

    private List<String> resolveWildcardSelectOptionValues(CommandLine commandLine, String name, InputComponent<?, ?> input) {
        List optionValues = commandLine.getOptionValues(name);
        ArrayList<String> resolvedOptionValues = new ArrayList();
        if (input instanceof SelectComponent) {
            Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)this.converterFactory, (SelectComponent)((SelectComponent)input));
            Iterable valueChoices = ((SelectComponent)input).getValueChoices();
            block0: for (Object choice : valueChoices) {
                String itemLabel = (String)itemLabelConverter.convert(choice);
                for (String optionValue : optionValues) {
                    String optionPattern = ResourcePathResolver.pathspecToRegEx((String)optionValue);
                    if (optionValue != null && optionValue.equals(optionPattern)) {
                        resolvedOptionValues.add(optionValue);
                        continue block0;
                    }
                    if (!itemLabel.matches(optionPattern)) continue;
                    resolvedOptionValues.add(itemLabel);
                    continue block0;
                }
            }
        } else {
            resolvedOptionValues = optionValues;
        }
        return resolvedOptionValues;
    }
}

