/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class CommandListCommand
extends AbstractShellCommand {
    @Inject
    private CommandFactory commandFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("command-list").description("List all available commands.");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Shell shell = (Shell)uiContext.getProvider();
        TerminalSize terminalSize = shell.getConsole().getShell().getSize();
        ArrayList<String> display = new ArrayList<String>();
        TreeSet<CommandInfo> commandInfos = new TreeSet<CommandInfo>();
        for (UICommand uICommand : this.commandFactory.getCommands()) {
            UICommandMetadata metadata = uICommand.getMetadata(uiContext);
            String name = this.commandFactory.getCommandName(uiContext, uICommand);
            boolean enabled = uICommand.isEnabled(uiContext);
            commandInfos.add(new CommandInfo(metadata.getCategory().toString(), name, metadata.getDescription(), enabled));
        }
        for (CommandInfo commandInfo : commandInfos) {
            display.add(commandInfo.category + " > " + new TerminalString(commandInfo.name, new TerminalColor(commandInfo.enabled ? Color.CYAN : Color.RED, Color.DEFAULT)).toString() + " - " + commandInfo.description);
        }
        UIOutput output = uiContext.getProvider().getOutput();
        PrintStream printStream = output.out();
        printStream.println(Parser.formatDisplayList((String[])display.toArray(new String[display.size()]), (int)terminalSize.getHeight(), (int)terminalSize.getWidth()));
        return Results.success();
    }

    private static class CommandInfo
    implements Comparable<CommandInfo> {
        final String category;
        final String name;
        final String description;
        final boolean enabled;

        CommandInfo(String category, String name, String description, boolean enabled) {
            this.category = category;
            this.name = name;
            this.description = description;
            this.enabled = enabled;
        }

        @Override
        public int compareTo(CommandInfo o) {
            int compareTo = this.category.compareTo(o.category);
            if (compareTo == 0) {
                compareTo = this.name.compareTo(o.name);
            }
            return compareTo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommandInfo other = (CommandInfo)obj;
            if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

