/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Lists;

public class MoveCommand
extends AbstractShellCommand {
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Arguments", required=true, type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public void validate(UIValidationContext validator) {
        Iterable value = this.arguments.getValue();
        if (value != null && Lists.toList((Iterable)value).size() != 2) {
            validator.addValidationError(this.arguments, "Only two arguments are accepted");
        }
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), MoveCommand.class).name("mv").description("Move a file or directory");
    }

    public Result execute(UIExecutionContext context) {
        UISelection initialSelection = context.getUIContext().getInitialSelection();
        Resource directory = (Resource)initialSelection.get();
        Iterator argIterator = this.arguments.getValue().iterator();
        FileResource<?> sourceResource = this.resolveFirstResource(directory, (String)argIterator.next());
        FileResource<?> targetResource = this.resolveFirstResource(directory, (String)argIterator.next());
        sourceResource.moveTo(targetResource);
        return Results.success();
    }

    private FileResource<?> resolveFirstResource(Resource<?> resource, String target) {
        if (!this.isFile(resource) || !this.isDirectory(resource)) {
            throw new RuntimeException(resource.getName() + " isn't a folder or file");
        }
        List results = resource.resolveChildren(target);
        if (results.size() > 1) {
            throw new RuntimeException("ambiguous target file name: " + target);
        }
        if (results.isEmpty()) {
            throw new RuntimeException("no resources found under path: " + target);
        }
        return (FileResource)((Resource)results.get(0)).reify(FileResource.class);
    }

    private boolean isFile(Resource<?> source) {
        return source instanceof FileResource;
    }

    private boolean isDirectory(Resource<?> source) {
        return source instanceof DirectoryResource;
    }
}

