/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ShellFactory;
import org.jboss.forge.addon.shell.ShellHandle;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;

public class ShellHandleImpl
implements ShellHandle {
    @Inject
    private ShellFactory shellFactory;
    private Shell shell;

    public void initialize(File currentResource, InputStream stdIn, PrintStream stdOut, PrintStream stdErr) {
        Settings settings = new SettingsBuilder().inputStream(stdIn).outputStream(stdOut).outputStreamError(stdErr).enableMan(true).create();
        this.shell = this.shellFactory.createShell(currentResource, settings);
    }

    public void destroy() {
        if (this.shell != null) {
            try {
                this.shell.close();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Error while closing Shell", e);
            }
        }
    }

    public void addCommandExecutionListener(CommandExecutionListener listener) {
        if (this.shell != null) {
            this.shell.addCommandExecutionListener(listener);
        }
    }
}

