/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.AbstractShellInteraction;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.output.UIMessage;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.furnace.util.Strings;

class CommandAdapter
implements Command<CommandInvocation> {
    private static final Logger log = Logger.getLogger(CommandAdapter.class.getName());
    private final ShellImpl shell;
    private final ShellContext shellContext;
    private final AbstractShellInteraction interaction;

    public CommandAdapter(ShellImpl shell, ShellContext shellContext, AbstractShellInteraction interaction) {
        this.shell = shell;
        this.shellContext = shellContext;
        this.interaction = interaction;
    }

    public List<UIMessage> validate() {
        return this.interaction.getController().validate();
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        Map attributeMap = this.shellContext.getAttributeMap();
        attributeMap.put(CommandInvocation.class, commandInvocation);
        boolean failure = false;
        try {
            failure = !this.interaction.promptRequiredMissingValues(this.shell);
        }
        catch (InterruptedException ie) {
            log.log(Level.FINE, "Caught InterruptedException while prompting in interactive mode", ie);
            failure = true;
        }
        if (!failure) {
            UIOutput output = this.shell.getOutput();
            for (UIMessage message : this.interaction.getController().validate()) {
                switch (message.getSeverity()) {
                    case ERROR: {
                        failure = true;
                        output.error(output.err(), message.getDescription());
                        break;
                    }
                    case INFO: {
                        output.info(output.out(), message.getDescription());
                        break;
                    }
                    case WARN: {
                        output.warn(output.out(), message.getDescription());
                    }
                }
            }
            if (!failure) {
                Object result;
                UISelection selection;
                Result commandResult = null;
                try {
                    commandResult = this.interaction.getController().execute();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to execute [" + this.interaction.getName() + "] due to exception.", e);
                    commandResult = Results.fail((String)e.getMessage(), (Throwable)e);
                }
                failure = this.displayResult(commandResult);
                if (!Boolean.TRUE.equals(attributeMap.get("org.jboss.forge.exit")) && (selection = this.interaction.getContext().getSelection()) != null && !selection.isEmpty() && (result = selection.get()) instanceof Resource) {
                    this.shell.setCurrentResource((Resource)result);
                }
            }
        }
        return failure ? CommandResult.FAILURE : CommandResult.SUCCESS;
    }

    private boolean displayResult(Result result) {
        boolean failure = false;
        if (result instanceof CompositeResult) {
            for (Result thisResult : ((CompositeResult)result).getResults()) {
                if (this.displayResult(thisResult)) continue;
                failure = true;
            }
        } else if (result != null && !Strings.isNullOrEmpty((String)result.getMessage())) {
            UIOutput output = this.shell.getOutput();
            if (result instanceof Failed) {
                output.error(output.err(), result.getMessage());
                log.log(Level.SEVERE, result.getMessage(), ((Failed)result).getException());
                failure = true;
            } else {
                output.success(output.out(), result.getMessage());
                failure = false;
            }
        }
        return failure;
    }
}

