/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.io.IOException;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.validator.CommandValidatorException;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.forge.addon.shell.ui.ShellContextImpl;

class ForgeCommandContainer
implements CommandContainer {
    private final ShellContextImpl context;
    private final CommandLineParser<?> parser;
    private final Command<CommandInvocation> command;

    ForgeCommandContainer(ShellContextImpl context, CommandLineParser<?> parser, Command<CommandInvocation> command) {
        this.context = context;
        this.parser = parser;
        this.command = command;
    }

    public void close() throws Exception {
        this.context.close();
    }

    public CommandLineParser<?> getParser() {
        return this.parser;
    }

    public boolean haveBuildError() {
        return false;
    }

    public String getBuildErrorMessage() {
        return null;
    }

    public String printHelp(String childCommandName) {
        return this.parser.getChildParser(childCommandName).printHelp();
    }

    public CommandContainerResult executeCommand(AeshLine line, InvocationProviders invocationProviders, AeshContext aeshContext, CommandInvocation commandInvocation) throws CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException, InterruptedException {
        CommandLine commandLine = this.parser.parse(line, false);
        commandLine.getParser().getCommandPopulator().populateObject(commandLine, invocationProviders, aeshContext, true);
        if (commandLine.getParser().getProcessedCommand().getValidator() != null && !commandLine.hasOptionWithOverrideRequired()) {
            this.parser.getProcessedCommand().getValidator().validate(this.command);
        }
        CommandResult result = this.command.execute(commandInvocation);
        return new CommandContainerResult(commandLine.getParser().getProcessedCommand().getResultHandler(), result);
    }
}

