/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.console.helper.ManProvider;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.CommandLineUtil;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Streams;

public class ForgeManProvider
implements ManProvider {
    private static final Logger log = Logger.getLogger(ForgeManProvider.class.getName());
    private final ShellImpl shell;
    private final CommandFactory manager;
    private final ConverterFactory converterFactory;
    private final InputComponentFactory inputComponentFactory;
    private final CommandLineUtil commandLineUtil;
    private final Comparator<? super InputComponent<?, ?>> SHORTNAME_COMPARATOR = (left, right) -> Character.valueOf(left.getShortName()).compareTo(Character.valueOf(right.getShortName()));
    private final Comparator<? super InputComponent<?, ?>> NAME_COMPARATOR = (left, right) -> left.getName().compareTo(right.getName());

    public ForgeManProvider(ShellImpl shell, CommandFactory manager, ConverterFactory converterFactory, InputComponentFactory inputComponentFactory, CommandLineUtil commandLineUtil) {
        this.shell = shell;
        this.manager = manager;
        this.converterFactory = converterFactory;
        this.inputComponentFactory = inputComponentFactory;
        this.commandLineUtil = commandLineUtil;
    }

    /*
     * Exception decompiling
     */
    public InputStream getManualDocument(String command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream buildDefaultManPage(UICommand cmd, final UIContext context) {
        try {
            URL template = this.getClass().getResource("DefaultManPage.txt");
            String result = Streams.toString((InputStream)template.openStream());
            final ArrayList inputs = new ArrayList();
            cmd.initializeUI(new UIBuilder(){

                public UIContext getUIContext() {
                    return context;
                }

                public UIBuilder add(InputComponent<?, ?> input) {
                    inputs.add(input);
                    return this;
                }

                public InputComponentFactory getInputComponentFactory() {
                    return ForgeManProvider.this.inputComponentFactory;
                }
            });
            result = result.replaceAll("%name%", this.manager.getCommandName(context, cmd));
            result = result.replaceAll("%description%", cmd.getMetadata(context).getCategory().toString());
            result = result.replaceAll("%synopsis%", this.buildSynopsis(cmd, context, inputs));
            result = result.replaceAll("%options%", this.buildOptions(cmd, context, inputs).trim());
            result = result.replaceAll("%addon%", this.getSourceAddonName(cmd, context));
            result = result.replaceAll("%year%", String.valueOf(Calendar.getInstance().get(1)));
            return new ByteArrayInputStream(result.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening stream to default man page.", e);
        }
    }

    private String getSourceAddonName(UICommand cmd, UIContext context) {
        return cmd.getMetadata(context).getType().getClassLoader().toString();
    }

    private String buildSynopsis(UICommand cmd, UIContext context, List<InputComponent<?, ?>> inputs) {
        StringBuilder result = new StringBuilder();
        result.append(this.manager.getCommandName(context, cmd)).append(" [-");
        Collections.sort(inputs, this.SHORTNAME_COMPARATOR);
        for (InputComponent<?, ?> input : inputs) {
            if (input.getShortName() == ' ' || !Boolean.class.equals((Object)input.getValueType())) continue;
            result.append(input.getShortName());
        }
        result.append("] ");
        Collections.sort(inputs, this.NAME_COMPARATOR);
        InputComponent<?, ?> arguments = null;
        for (InputComponent<?, ?> input : inputs) {
            if ("arguments".equals(input.getName())) {
                arguments = input;
                continue;
            }
            if (!input.isRequired()) continue;
            result.append("[");
            if (input.getShortName() != ' ') {
                result.append("-").append(input.getShortName()).append(" ");
            }
            result.append("--").append(this.commandLineUtil.toOptionName(input.getName())).append("] ");
            result.append(input.getValueType().getSimpleName()).append(" ");
        }
        if (arguments != null) {
            result.append("[ ... ").append(arguments.getLabel() == null ? " args" : arguments.getLabel()).append("] ");
            result.append(arguments.getValueType().getSimpleName()).append(" ");
        }
        return result.toString();
    }

    private String buildOptions(UICommand cmd, UIContext context, List<InputComponent<?, ?>> inputs) {
        StringBuilder result = new StringBuilder();
        UICommandMetadata metadata = cmd.getMetadata(context);
        if (metadata.getLongDescription() != null) {
            result.append(metadata.getLongDescription().trim());
        } else if (metadata.getDescription() != null) {
            result.append(metadata.getDescription().trim());
        }
        if (UIWizard.class.isAssignableFrom(metadata.getType())) {
            result.append(" (*multi-step wizard* - some options may not be auto-documented in this man page.)");
        }
        result.append(OperatingSystemUtils.getLineSeparator()).append(OperatingSystemUtils.getLineSeparator());
        Collections.sort(inputs, this.SHORTNAME_COMPARATOR);
        InputComponent<?, ?> arguments = null;
        for (InputComponent<?, ?> input : inputs) {
            if ("arguments".equals(input.getName())) {
                arguments = input;
                continue;
            }
            result.append("*");
            if (input.getShortName() != ' ') {
                result.append("-").append(input.getShortName()).append(", ");
            } else {
                result.append("   ");
            }
            result.append("--").append(this.commandLineUtil.toOptionName(input.getName())).append("*");
            result.append(OperatingSystemUtils.getLineSeparator());
            result.append("        ");
            if (!input.getName().equals(input.getLabel())) {
                result.append(input.getLabel() == null ? "" : input.getLabel());
                if (input.getLabel() != null && input.getDescription() != null) {
                    result.append(" - ");
                }
            }
            result.append(input.getDescription() == null ? "" : input.getDescription());
            result.append(" [").append(input.getValueType().getSimpleName()).append("]");
            if (input.isRequired()) {
                result.append(" (*required*)");
            }
            if (input instanceof SelectComponent) {
                Object itemLabel;
                result.append(" Valid choices: [");
                Iterable valueChoices = ((SelectComponent)input).getValueChoices();
                Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)this.converterFactory, (SelectComponent)((SelectComponent)input));
                for (Object choice : valueChoices) {
                    if (choice == null) continue;
                    itemLabel = itemLabelConverter.convert(choice);
                    result.append("\"").append(itemLabel).append("\" ");
                }
                result.append("] ");
                if (input.hasDefaultValue() && input.hasValue()) {
                    result.append(" defaults to: [");
                    if (input instanceof ManyValued) {
                        Iterable values = ((ManyValued)input).getValue();
                        if (values.iterator().hasNext()) {
                            Object choice;
                            choice = values.iterator();
                            while (choice.hasNext()) {
                                Object value = choice.next();
                                if (value == null) continue;
                                Object itemLabel2 = value.toString();
                                if (itemLabelConverter != null) {
                                    itemLabel2 = itemLabelConverter.convert(value);
                                }
                                result.append("\"").append(itemLabel2).append("\" ");
                            }
                        } else {
                            Object value = input.getValue();
                            if (value != null) {
                                itemLabel = value.toString();
                                if (itemLabelConverter != null) {
                                    itemLabel = itemLabelConverter.convert(value);
                                }
                                result.append("\"").append(itemLabel).append("\" ");
                            }
                        }
                    }
                    result.append("]");
                }
            } else if (input.hasDefaultValue()) {
                result.append(" defaults to: [" + input.getValue() + "]");
            }
            result.append(OperatingSystemUtils.getLineSeparator()).append(OperatingSystemUtils.getLineSeparator());
        }
        if (arguments != null) {
            result.append("[");
            if (arguments.getLabel() == null) {
                result.append("L ").append(arguments.getValueType().getSimpleName()).append("; ... arguments");
            } else {
                result.append(arguments.getLabel());
            }
            result.append("] ");
        }
        return result.toString();
    }
}

