/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.reader.AeshStandardStream;
import org.jboss.aesh.console.reader.ConsoleInputSession;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.util.ANSI;
import org.jboss.forge.addon.shell.spi.Terminal;

public class ForgeTerminal
implements org.jboss.aesh.terminal.Terminal,
Shell {
    private final Terminal delegate;
    private ConsoleInputSession inputSession;
    private PrintStream stdOut;
    private PrintStream stdErr;
    private Settings settings;
    private boolean mainBuffer = true;
    private boolean echoEnabled;
    private TerminalSize terminalSize;
    private static final Logger logger = Logger.getLogger(ForgeTerminal.class.getName());

    public ForgeTerminal(Terminal delegate) {
        this.delegate = delegate;
    }

    public void init(Settings settings) {
        this.settings = settings;
        this.inputSession = new ConsoleInputSession(settings.getInputStream());
        this.stdOut = settings.getStdOut();
        this.stdErr = settings.getStdErr();
        this.delegate.initialize();
    }

    public CursorPosition getCursor() {
        if (this.settings.isAnsiConsole() && Config.isOSPOSIXCompatible()) {
            try {
                StringBuilder col = new StringBuilder(4);
                StringBuilder row = new StringBuilder(4);
                this.out().print("\u001b[6n");
                this.out().flush();
                boolean gotSep = false;
                int[] input = this.read();
                for (int i = 2; i < input.length - 1; ++i) {
                    if (input[i] == 59) {
                        gotSep = true;
                        continue;
                    }
                    if (gotSep) {
                        col.append((char)input[i]);
                        continue;
                    }
                    row.append((char)input[i]);
                }
                return new CursorPosition(Integer.parseInt(row.toString()), Integer.parseInt(col.toString()));
            }
            catch (Exception e) {
                if (this.settings.isLogging()) {
                    logger.log(Level.SEVERE, "Failed to find current row with ansi code: ", e);
                }
                return new CursorPosition(-1, -1);
            }
        }
        return new CursorPosition(-1, -1);
    }

    public void setCursor(CursorPosition position) {
        if (this.getSize().isPositionWithinSize(position)) {
            this.out().print(position.asAnsi());
            this.out().flush();
        }
    }

    public void moveCursor(int rows, int columns) {
        CursorPosition cp = this.getCursor();
        cp.move(rows, columns);
        if (this.getSize().isPositionWithinSize(cp)) {
            this.setCursor(cp);
        }
    }

    public void clear() {
        this.out().print(ANSI.CLEAR_SCREEN);
        this.out().flush();
    }

    public boolean isMainBuffer() {
        return this.mainBuffer;
    }

    public void enableAlternateBuffer() {
        if (this.isMainBuffer()) {
            this.out().print(ANSI.ALTERNATE_BUFFER);
            this.out().flush();
            this.mainBuffer = false;
        }
    }

    public void enableMainBuffer() {
        if (!this.isMainBuffer()) {
            this.out().print(ANSI.MAIN_BUFFER);
            this.out().flush();
            this.mainBuffer = true;
        }
    }

    public int[] read() throws IOException {
        return this.inputSession.readAll();
    }

    public boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public Shell getShell() {
        return this;
    }

    public AeshStandardStream in() {
        return null;
    }

    public PrintStream err() {
        return this.stdErr;
    }

    public PrintStream out() {
        return this.stdOut;
    }

    public void reset() throws IOException {
    }

    public TerminalSize getSize() {
        int height = this.delegate.getHeight();
        int width = this.delegate.getWidth();
        if (this.terminalSize == null || this.terminalSize.getHeight() != height || this.terminalSize.getWidth() != width) {
            this.terminalSize = new TerminalSize(height, width);
        }
        return this.terminalSize;
    }

    public void close() throws IOException {
        this.inputSession.stop();
        this.delegate.close();
    }

    public void writeToInputStream(String data) {
        this.inputSession.writeToInput(data);
    }

    public void changeOutputStream(PrintStream output) {
        this.stdOut = output;
    }

    public boolean hasInput() {
        return this.inputSession.hasInput();
    }
}

